/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.concurrent.TimeoutException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

public abstract class BridgeToCanOpenHardware
extends Module
implements BridgeToHardware {
    protected CanOpenProxy tcpProxy;
    private boolean hardwareInitialized = false;
    private boolean configurationChecked = false;

    public BridgeToCanOpenHardware(String aName, int aTickMillis, CanOpenProxy tcpProxy) {
        super(aName, aTickMillis);
        this.tcpProxy = tcpProxy;
    }

    public abstract PieceOfHardware[] listHardware();

    @Override
    public CanOpenProxy getTcpProxy() {
        return this.tcpProxy;
    }

    @Override
    public void startThreadReader() {
        this.tcpProxy.startThreadReader();
    }

    @Override
    public boolean isCWrapperConnected() {
        return this.tcpProxy.isReady(this.tcpProxy.getMyClientName());
    }

    @Override
    public boolean isHardwareReady() {
        return this.tcpProxy.isHardwareReady();
    }

    public void initModule() {
        log.info((Object)("INIT MODULE" + this.getName()), new String[0]);
        PieceOfHardware[] hardwareList = this.listHardware();
        this.tcpProxy.hardwareList = hardwareList;
        int numberOfNodes = hardwareList.length;
        this.tcpProxy.setExpectedNodesNB(numberOfNodes);
        log.info((Object)("Number of pieces of hardware expected =" + numberOfNodes), new String[0]);
        try {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
        }
        catch (DeploymentException ex) {
            log.error((Object)(String.valueOf(ex.getMessage()) + ": Could not load CanOpen Error Tables"), new String[0]);
            this.getSubsystem().updateState(State.InError, "Could not load CanOpen Error Tables");
        }
    }

    public Object sendCanOpen(String command) throws InterruptedException, TimeoutException, BadCommandException {
        return this.tcpProxy.sendCanOpen(command);
    }

    @Override
    public CanOpenProxy.PDOStorage readPDOs() throws HardwareException, BadCommandException {
        log.debug((Object)(String.valueOf(this.name) + "/readPDOS"), new String[0]);
        return this.tcpProxy.readPDOs();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/hardware list={");
        PieceOfHardware[] pieceOfHardwareArray = this.listHardware();
        int n = pieceOfHardwareArray.length;
        int n2 = 0;
        while (n2 < n) {
            PieceOfHardware p = pieceOfHardwareArray[n2];
            sb.append(" ");
            sb.append(p.toString());
            sb.append(";");
            ++n2;
        }
        sb.append("}");
        return sb.toString();
    }
}

