/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public abstract class ClampActuatorModule
extends Module
implements Actuator {
    public boolean on;
    public int readValue;
    public int sentValue;
    public int sentCurrentMinValue;
    public int sentCurrentMaxValue;

    @Override
    public boolean isOff() {
        return !this.on;
    }

    @Override
    public boolean isOn() {
        return this.on;
    }

    @Override
    public int getReadValue() {
        return this.readValue;
    }

    @Override
    public int getSentValue() {
        return this.sentValue;
    }

    @Override
    public int getSentCurrentMaxValue() {
        return this.sentCurrentMaxValue;
    }

    @Override
    public int getSentCurrentMinValue() {
        return this.sentCurrentMinValue;
    }

    public void initModule() {
        this.on = false;
        this.readValue = 0;
        this.sentValue = 0;
    }

    @Override
    public abstract String on() throws BadCommandException, ErrorInCommandExecutionException;

    @Override
    public abstract String off() throws BadCommandException, ErrorInCommandExecutionException;

    public abstract String maintainUnclamped() throws BadCommandException, ErrorInCommandExecutionException;

    public abstract int getMotor_continuousCurrentLimit();

    public abstract int getMotor_maxSpeedInCurrentMode();

    public abstract String getMotor_mode();

    public abstract int getMotor_outputCurrentLimit();

    public abstract int getMotor_polePairNumber();

    public abstract int getMotor_thermalTimeConstantWinding();

    public abstract int getMotor_type();

    public abstract String getNodeID();

    public abstract int getPositionSensorType();

    public abstract String getSerialNB();

    public StatusDataPublishedByClampActuator getStatusData() {
        return FcsUtils.createStatusDataPublishedByClampActuator(this);
    }
}

