/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS24;

/**
 * This is the Main Module for the LPSC test bench control software.
 * The test bench is to test the hardware of the loader.
 * @author virieux
 */
public class LPSCTestBenchMainModule  extends MainModule {
   
    CanOpenEPOS24 hookMotor;
    

    public LPSCTestBenchMainModule(String aName, int aTickMillis, BridgeToHardware bridge) {
        super(aName, aTickMillis, bridge);
    }

    public void initModule() {
        super.initModule();
        hookMotor = (CanOpenEPOS24) this.getModule("hookMotor");
    }
    
    
    void openHooks() throws BadCommandException, ErrorInCommandExecutionException  {  
        hookMotor.on();
    }
    
    
    void closeHooks() {       
    }
    
    
}
