/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS24;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenPlutoGateway;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;


/**
 * This subsystem is to read some sensors in CPPM through the pluto gateway.
 * @author virieux
 */
public class CPPMTestBenchMainModule extends Module {


    BridgeToCanOpenHardware bridge;
    
    CanOpenPlutoGateway plutoGW;
    
    CanOpenEPOS24 epos;

    public CPPMTestBenchMainModule(String aName, int aTickMillis, BridgeToCanOpenHardware aBridge) {
        super(aName, aTickMillis);
        this.bridge = aBridge;
    }


    @Override
    public void initModule() {
        super.initModule();
        plutoGW = (CanOpenPlutoGateway) this.getModule("plutoGW");
        epos = (CanOpenEPOS24) this.getModule("epos");
    }
      
    /**
     * Read the sensors through the pluto gateway.
     * @return
     * @throws HardwareException 
     */
    public String readSensors() throws HardwareException {
        String hexaValue = this.plutoGW.readSDO("6004", "03");
        
        String bin = Integer.toBinaryString(Integer.parseInt(hexaValue, 16));
        
        System.out.println(bin);
        return bin;
    }
    
    /**
     * To enable the EPOS controller.
     * POUR PATRICK :
     * This can be done too from the console with the command:
     * console> invoke testbenchCPPM/epos enable
     * This is true for all the methods in CAnOpenEPOS.
     * @return
     * @throws SDORequestException 
     */
    public String enableEPOS() throws SDORequestException {
        this.epos.enable();
        return (this.epos.getName() + " is enable");
    }
    
}
