/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.singlefiltertest;


import java.util.List;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.common.GenericLatch;
import org.lsst.ccs.subsystems.fcs.common.Motor;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

/**
 * This class is for the Single Filter Test carousel.
 * The carousel in Single Filter Test has only one socket and
 * doesn't rotate.
 *
 * @author virieux
 */
public class SftCarouselModule extends CarouselModule {

    public SftCarouselModule(String aName, int aTickMillis, Motor carouselMotor, GenericLatch brake, int nbSockets, List<CarouselSocket> socketsList) {
        super(aName, aTickMillis, carouselMotor, brake, nbSockets, socketsList);
    }
    

    
    
    @Override
    public CarouselSocket getSocketAtStandby() {
        return getSockets()[0];
    }

    @Override
    public double getPosition() {
        return 0;
    }
    
    /**
     * This method reads the clamps sensors and update the clamps state AND
     * put or remove the filter (software) on the socket at standby.
     * Command to be used in Engineering mode when we execute actions step by step.
     * @throws HardwareError
     * @throws BadCommandException 
     */
    public void updateStateWithSensors() throws HardwareException, BadCommandException {

        if (this.getSocketAtStandby() == null) {
            throw new BadCommandException("Unable to read sensors when there is no socket at standby.");
        }
        //this.getSocketAtStandby().updateClampsStateWithSensors();
        this.updateClampsStateWithSensors();
        
        Filter dummyFilter = ((SftMainModule) this.getModule("main")).getDummyFilter();
        if (this.getSocketAtStandby().isClampedOnFilter() 
                || this.getSocketAtStandby().isUnclampedOnFilter()) {
            this.getSocketAtStandby().putFilterOnSocket(dummyFilter);
        } else {
            if (!(this.getSocketAtStandby().getFilter() == null)) {
                //this can happen only in engineering mode when we move the mechanic step by step
                this.getSocketAtStandby().removeFilter();
            }
        }
        
    }
    
    public void updateClampsStateWithSensors() throws BadCommandException, HardwareException {
        updateClampsStateWithSensorsFromPDO();
    }
    

    @Override
    public boolean isAbleToMove() {
        return false;
    }

    public boolean isRotating() {
        return false;
    }

    @Override
    public String rotate(double angle) {
        throw new UnsupportedOperationException("Operation rotate not available in Single Filter Test");
    }

    @Override
    public String stop () {
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }
    

    @Override
    public String lock() {
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }

    @Override
    public String unlock(){
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }


}
