/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.TruckModule;

/**
 * A simulated truck used by the simulated hardware control software.
 * @author virieux
 */
public class SimuTruckModule extends TruckModule {

    public SimuTruckModule(String aName,int aTickMillis, NumericSensor railSensorStandback, NumericSensor railSensorStandby) {
        super(aName, aTickMillis, railSensorStandback, railSensorStandby);
    }
    
    

    
    /**
     * In the single filter test, the simultated presence filter sensor listens to the
     * simulated truck so we have to notify our observers.
     * 
     * @throws ErrorInCommandExecutionException 
     */
    @Override
    public synchronized void updateLocation(String hex) throws ErrorInCommandExecutionException {
        super.updateLocation(hex);
        setChanged();
        this.notifyObservers(new ValueUpdate(getName(), getTruckLocation()));
    }
    
    public String toString() {
        return super.toString();
    }
                
}
