/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy.PDOStorage;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

/**
 * This is a Model for a sensor on a can open bus which communicates over Can Open protocol.
 * The sensor is supposed to be connected to a ADC with analogics input.(CAN-CBX-AI814)
 * @author virieux
 */
public class CanOpenSensor14bits extends Sensor14bits {
    
    
    
     /**
     * The ADC on which this sensor is plugged.
     */
    CanOpenADC adc;
    
    /**
     * This is the name of the ADC in the groovy file which is used in initModule.
     * 
     */
    String adcName;
    
    /**
     * The numero of analog input where the sensor is plugged.
     */
    int numOfAnalogInput;

    public CanOpenSensor14bits(String moduleName, int aTickMillis, String adcName, int numOfAnalogInput) {
        super(moduleName, aTickMillis);
        this.adcName = adcName;
        this.numOfAnalogInput = numOfAnalogInput;
    }
    
    
    
    
    /**************************************************************************************************/
    /********************** SETTERS AND GETTERS  ******************************************************/
    /**************************************************************************************************/
    
    

    public void setAdcName(String adcName) {
        this.adcName = adcName;
    }
 

    public void setNumOfAnalogInput(int numOfAnalogInput) {
        this.numOfAnalogInput = numOfAnalogInput;
    }
    
    /**************************************************************************************************/
    /********************** END OF SETTERS AND GETTERS  ***********************************************/
    /**************************************************************************************************/
    
    public void initModule() {
        this.adc = (CanOpenADC) this.getModule(adcName);
    }

    @Override
    public int readNewValue() throws HardwareException {
//        try {
            String valueInHexa = adc.readAnalogInput(numOfAnalogInput);
            
            value = Integer.parseInt(valueInHexa, 16);
            return value;
            
//        } catch (SDORequestError ex) {
//            log.error(getName() + " CanOpen Error in reading sensor " + ex.getMessage());
//            this.getSubsystem().updateState(State.InError,getName() + " CanOpen Error in reading sensor:" + ex.getMessage());
//        } catch (HardwareNotDetectedException ex) {
//            log.error(ex);
//            this.getSubsystem().updateState(State.InError, getName() 
//                          +  " not booted or error in config." + ex.getMessage());
//        }
//        return 0;
    }

    @Override
    public int updateValue(PDOStorage pdoStorage) {
        String hexaValue = pdoStorage.getVarValue(this.adc.nodeID, Integer.toString(this.numOfAnalogInput));
        this.value = Integer.parseInt(hexaValue, 16);
        return this.value;
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/adcName=");sb.append(this.adcName);
        sb.append("/inputNumero=");sb.append(this.numOfAnalogInput);
        return sb.toString();
    }
    
    





}
