/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 *
 * @author virieux
 */
public class CanOpenPlutoGateway extends CanOpenDevice {

    public CanOpenPlutoGateway(String aName, int aTickMillis, String nodeID, String serialNB) {
        super(aName, aTickMillis, nodeID, serialNB);
    }
    
    
    
    @Override
    public String initializeHardware() throws SDORequestException, ErrorInCommandExecutionException {
        return configure();        
    }
    
    public String configure() throws SDORequestException, ErrorInCommandExecutionException {
        String ack = this.writeSDO("2002", "01", "01", "04");
        String goodAck = "OK";
        if (!ack.equals(goodAck)) throw new ErrorInCommandExecutionException(getName() + " :bad returned ack for wsdo, index 2002");
        return (getName() + " is configured.");
    }
}
