/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 * This is the driver class for the DAC we use in the FCS test bench: 
 * CAN-CBX-AO412
 * @author virieux
 */
//public class CanOpenDAC extends Module implements PieceOfHardware {
public class CanOpenDAC extends CanOpenDevice {
    
    /**
    * In order to have 1 Volt send to the output we have to write 3210.27287 in decimal.
    * 
    */
    public static final double bitOverVolts = 3210.27287;


    public CanOpenDAC(String aName, int aTickMillis, String nodeID, String serialNB) {
        super(aName, aTickMillis, nodeID, serialNB);
    }

    

        
    /**************************************************************************************************/
    /********************** SETTERS AND GETTERS  ******************************************************/
    /**************************************************************************************************/
    

    /**************************************************************************************************/
    /********************** END OF SETTERS AND GETTERS  ***********************************************/
    /**************************************************************************************************/

    

    
    /**
     * Write a value to the output of the DAC
     * @param inputNB in 0..4
     * @param value given in decimal format
     */
    public void writeAnalogOutput(int inputNB, int value) throws SDORequestException, HardwareNotDetectedException {
        
        if (!this.tcpProxy.isBooted(this)) {
            String message = String.format("DAC %s / nodeID=%s is NOT BOOTED", getName(),nodeID);
            log.error(message);
            //this.getSubsystem().updateState(State.InError, message );
            
            throw new HardwareNotDetectedException("CanOpenDAC is MISSING", getName(),this.nodeID, this.serialNB);
        }
        
        if ((inputNB < 1) || (inputNB > 4)) 
            throw new IllegalArgumentException("CAN-CBX-AO412 : input has to be 1..4");
        //TODO test the value < 65535
        String valueInHexa = Integer.toHexString(value);
        String inputNBInHexa = Integer.toHexString(inputNB);
        tcpProxy.writeSDO(nodeID, "6411", inputNBInHexa, "2", valueInHexa);
    }


    
//    public String toString() {
//        StringBuilder sb = new StringBuilder(getName());
//        sb.append("/");
//        sb.append(this.serialNB);
//        sb.append("/");
//        // because the configuration system can call toString before the object is completely built
//        // for tracing purpose.
//        if (tcpProxy == null ) return sb.toString();
//        if (isConfigOK())  {
//            sb.append("is booted");
//            sb.append("/CanOpen NodeID in hexa= ");
//            sb.append(this.nodeID);
//            int x = Integer.getInteger(this.nodeID, 16);
//            sb.append(" in decimal= ");sb.append(x);
//        } else {
//            sb.append("NOT DETECTED");
//        }
//        return sb.toString();
//    }
    

    



    
}
