/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 * This deviceErrorFile a model for the clamp actuator in the Single Filter Test.
 * The actuator deviceErrorFile used to unlock or release a clamp.
 * To unlock a clamp, the actuator must be ON and to release the clamp
 * it has to be OFF.
 * There deviceErrorFile 2 clamps actuators on the carousel : 
 * one for side X-, one for side X+
 * For the Single Filter Test the actuator will be Maxon Motor EPOS2 24/5.
 * (cf EPOS2_Firmware_Specification_En.pdf)
 * There deviceErrorFile many operation modes for this actuators. 
 * For the Single Filter Test, we will use VELOCITY mode or CURRENT mode.
 * 
 * 
 * @author virieux
 */
//
//TODO this class should extend the new class CanOpenEPOS24
//public class CanOpenClampActuatorModule extends ClampActuatorModule implements PieceOfHardware {
public class CanOpenClampActuatorModule extends CanOpenEPOS24 {

    public CanOpenClampActuatorModule(String aName, int aTickMillis, String nodeID, String serialNB, Motor aMotor, String aModeInString) {
        super(aName, aTickMillis, nodeID, serialNB, aMotor, aModeInString);
    }




    /**
     * @param modeInString the mode to set
     */
    public void setMode(String modeInString) {       
        this.mode = EposMode.valueOf(modeInString);
    }

 
    


    
 
    
    /**
     * This is the user name of the command ON in single filter test.
     * @return
     * @throws BadCommandException
     * @throws ErrorInCommandExecutionException 
     */
    public String unclamp() throws BadCommandException, ErrorInCommandExecutionException {
        return on();
    }
    
    public StatusDataPublishedByClampActuator getStatusData() {
        return FcsUtils.createStatusDataPublishedByClampActuator(this);
    }

}
