/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;

/**
 * This is the Main Module for every software related to the Filters Exchanger :
 * - single-filter-test control-command
 * - scale 1 prototype control-command
 * - real Filters Exchanger
 * This class is designed to gather the commons methods to all these softwares.
 *
 * @author virieux
 */
public abstract class MainModule extends Module {
    protected BridgeToHardware bridge;
    protected boolean hardwareReady;

    public MainModule(String aName, int aTickMillis, BridgeToHardware bridge) {
        super(aName, aTickMillis);
        this.bridge = bridge;
    }

    public void initModule() {
        this.bridge.startThreadReader();
    }
    
    /**
     * This methods updates the boolean hardwareReady from the hardware bridge.
     * But when the hardware is ready, it doesn't not ask hardware bridge again to avoid
     * too much messages on the log bus, could be replace by :
     * return this.bridge.isHardwareReady();
     * @return true if hardware is booted, identified and initialized
     */
    public boolean isHardwareReady() {
        if (hardwareReady) {
            return this.hardwareReady;
        } else {
            this.hardwareReady = this.bridge.isHardwareReady();
            return this.hardwareReady;
        }
    }
    
    public String toString() {
        return super.toString();
    }


    
}
