package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.subsystems.fcs.common.FilterLocation;

/**
 * This is a model for an optical filter for the camera.
 * 
 */
public class Filter {
	
	private Integer filterID;
	private String name;
	private double weight;
	private FilterLocation filterLocation = FilterLocation.UNKNOWN;
	
	//for Hibernate
	public Filter () {}

	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}

        /**
         * 
         * @return true if the filter is held by the carousel.
         */
	public boolean isOnCarousel() {
		return this.filterLocation == FilterLocation.ONCAROUSEL;
	}
		
        /**
         * 
         * @return true if the filter is held by the autochanger.
         */
	public boolean isOnAutoChanger() {
		return this.filterLocation == FilterLocation.ONAUTOCHANGER;
	}
	
        
        /**
         * 
         * @return true if the filter is out the camera.
         */
	public boolean isOut() {
		return this.filterLocation == FilterLocation.OUT;
	}
	
        /**
         * 
         * @return true if the location of the filter is unknown.
         */
	public boolean isUnknown() {
		return this.filterLocation == FilterLocation.UNKNOWN;
	}

	public FilterLocation getFilterLocation() {
		return filterLocation;
	}

	public void setFilterLocation(FilterLocation filterLocation) {
		this.filterLocation = filterLocation;
	}

	public Integer getFilterID() {
		return filterID;
	}

	public void setFilterID(Integer filterID) {
		this.filterID = filterID;
	}

	public double getWeight() {
		return weight;
	}

	public void setWeight(double weight) {
		this.weight = weight;
	}
        
        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            sb.append("/Weight=");sb.append(weight);
            return sb.toString();
        }



}
