// see documentation on single-filter-test on : https://confluence.slac.stanford.edu/display/LSSTCAM/Single+Filter+Test
package sft

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.singlefiltertest.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.startup.CCSBuilder ;


import static org.lsst.gruth.jutils.MapArgs.*
import static org.lsst.gruth.nodes.NodeUtils.loopList

//because in single-filter-test there is only one filter
def socketNumber = 1

//Carousel Can Open Devices (CAN-CBX-AI814)
def adcName = "ai814"

//Autochanger Can Open Devices
def dacName = "ao412"  // to control the latches actuator
def railsSensorsDIOName = "railsSensorsDIO"  // to control the trucks and monitor the rails sensors
def filterSensorsDIOName = "filterSensorsDIO" // to monitor the filter sensors

CCSBuilder builder = ["single filter test"]

builder.
        "Main Module" ( SftMainModule,
                argMap(a("name", "main"),
                        anInt("tickMillis", 3000),
                        ref("bridge"),
                        ref("dummyFilter")))
                 


            //begin description of Main submodules
            {       
                //-------------------------
                // BEGIN Bridge description
                // Bridge
                bridge (SimuBridgeToCanOpenHardware,
                        argMap(aString("name", "bridge"),
                            anInt("tickMillis", 1000)
                            ))


                //-------------------------
                // BEGIN Filter description

                dummyFilter (Filter, argMap(aString("name", "dummyFilter"))) //ok

                // END Filter description
                // ------------------------

                //----------------------------
                // BEGIN Carousel description
                carousel (anImpl(Carousel, SimuSftCarouselModule),
                        argMap( a("name", "carousel"),
                                anInt("tickMillis",5000),
                                //use getChildren for following lines
                                aRef("carouselMotor", "simuCarouselMotor"),
                                ref("clampActuatorXminus"),
                                ref("clampActuatorXplus"),
                                aRef("brake", "carouselLatch"),
                                anInt("nbSockets", socketNumber) ,
                                a("sockets", loopList(socketNumber, {ref ("socket$it")})) ))
                        
                {//begin description of carousel's children

                    carouselLatch ( anImpl(GenericLatch,CarouselLatch),
                            argMap(aString("name", "carouselLatch")))

                    
                    //just to be compatible with the real carousel
                    simuCarouselMotor (anImpl(Motor,SimuCarouselMotor),
                            argMap( a("name", "simuCarouselMotor") ,
                                    anInt("tickMillis",3000),
                                    aString("serialNumber","CCS-FCS-simu-CarouselMotor-20100718-1"),
                                    aDbl("nominalVelocity",21.0),
                                    aDbl("maximalVelocity", 21.8 ))) // OK
                            
                    clampActuatorXminus (anImpl(Actuator, SimuClampActuatorModule),
                                argMap( a("name", "clampActuatorXminus"),
                                anInt("sentCurrentMaxValue", 1780),
                                anInt("tickMillis",3000)))  
                    
                    clampActuatorXplus (anImpl(Actuator, SimuClampActuatorModule),
                                argMap( a("name", "clampActuatorXplus"),
                                anInt("sentCurrentMaxValue", 560),
                                anInt("tickMillis",3000)))

                    /* macro generation of Sockets */
                    //for (int ix= 0; ix < socketNumber; ix++){
                    int ix = 0 ;
                        "socket$ix" ( SimuCarouselSocket,
                                argMap(aDbl("position", "0.0"),
                                        aDbl("standbyPosition", "0.0"),
                                        aRef("clampXminus", "clampXminus"),
                                        aRef("clampXplus", "clampXplus")))

                                {   
                                    //-------------------------
                                    // BEGIN clampXminus description
                                    // TRANSITION no object numbering
                                    //"clampXminus$ix" (anImpl(FilterClampModule, SimuFilterClampXminusModule),
                                     "clampXminus" (anImpl(FilterClampModule, simulation.SimuFilterClampXminusModule),
                                            //argMap( a("name", "clampXminus$ix"),
                                             argMap( a("name", "clampXminus"),
                                                    anInt("tickMillis",5000),
                                                    //ref("dummyFilter"),
                                                    // actuator clmapActuatorXminus
                                                    aRef("filterPresenceSensor","filterPresenceXminus"),
                                                     //aRef("filterPresenceSensor","filterPresenceXminus$ix"),
                                                    anInt("filterPositionValueA", 1500, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                                                    anInt("filterPositionValueB", 24400, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                                                    anInt("filterPositionValueC", 32000 , [description:"above valueC, there is NOFILTER",constraints:0..32768]),
                                                    aRef("lockSensor", "lockSensorXminus"),
                                                     //aRef("lockSensor", "lockSensorXminus$ix"),
                                                    anInt("lockSensorValueA", 5000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                                                    anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                                                    anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                                                    aRef("thermometer", "thermometerXminus")))
                                    {
                                        "filterPresenceXminus" (anImpl(Sensor14bits, SimuClampFilterPresenceSensor),
                                                argMap( a("name", "filterPresenceXminus"),
                                                    //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                    anInt("value",5000,[description:"when the simulated sft starts the filter is LOCKABLE",constraints:0..32768])
                                                    ))


                                        "lockSensorXminus" (anImpl(Sensor14bits, SimuClampLockSensor),
                                                argMap( a("name", "lockSensorXminus"),
                                                    //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                    anInt("value",29000, [description:"when the simulated sft starts the clamps are LOCKED",constraints:0..32768])
                                                    ))


                                    }.calls {
                                        it.setActuator(ref("clampActuatorXminus"))

                                    }
                                    //-------------------------
                                    // END clampXminus description

                                    //-------------------------
                                    // BEGIN clampXplus description
                                    // TRANSITION no object numbering
                                    //"clampXplus$ix" (anImpl(FilterClampModule, SimuFilterClampXminusModule),
                                    "clampXplus" (anImpl(FilterClampModule, simulation.SimuFilterClampXplusModule),
                                            //argMap( a("name", "clampXplus$ix"),
                                            argMap( a("name", "clampXplus"),
                                                    anInt("tickMillis",5000),
                                                    //ref("dummyFilter"),
                                                    // actuator clmapAcutatorplusX
                                                    aRef("filterPresenceSensor","filterPresenceXplus"),
                                                    //aRef("filterPresenceSensor","filterPresenceXplus$ix"),
                                                    anInt("filterPositionValueA", 1355, [description:"below valueA, there is an ERROR",constraints:0..32768]),
                                                    anInt("filterPositionValueB", 10500, [description:"between valueA and valueB the filter is LOCKABLE, between valueB and valueC the filter is NOT_LOCKABLE",constraints:0..32768]),
                                                    anInt("filterPositionValueC", 32000, [description:"above valueC, there is NOFILTER",constraints:0..32768] ),
                                                    aRef("lockSensor", "lockSensorXplus"),
                                                    //aRef("lockSensor", "lockSensorXminus$ix"),
                                                    anInt("lockSensorValueA", 6000, [description:"below valueA the clamp is UNLOCKED",constraints:0..32768]),
                                                    anInt("lockSensorValueB", 28800, [description:"between valueA and valueB the filter is UNDEFINED, between valueB and valueC the filter is LOCKED",constraints:0..32768]),
                                                    anInt("lockSensorValueC", 32000, [description:"above valueC, there is an ERROR",constraints:0..32768]),
                                                    anInt("timeoutUnlock", 4000, [description:"a timeout when we unlock this clamp",constraints:0..10000]),
                                                    anInt("timeoutRelease", 4000, [description:"a timeout when we release this clamp",constraints:0..10000]),
                                                    aRef("thermometer", "thermometerXplus")))
                                    {
                                        "filterPresenceXplus" (anImpl(Sensor14bits, SimuClampFilterPresenceSensor),
                                                argMap( a("name", "filterPresenceXplus"),
                                                        //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                        anInt("value",5000,[description:"when the simulated sft starts the filter is LOCKABLE"])
                                                        ))


                                        "lockSensorXplus" (anImpl(Sensor14bits, SimuClampLockSensor),
                                                argMap( a("name", "lockSensorXplus"),
                                                        //aString("adcName",adcName,[static:true,description:"The name of the ADC where this sensor is plugged."]),
                                                        anInt("value",29000, [description:"when the simulated sft starts the clamps are LOCKED",constraints:0..32768])))


                                    }.calls {
                                        it.setActuator(ref("clampActuatorXplus"))
                                    }
                                    //-------------------------
                                    // END clampXplus description
                                    
                                }.calls {
                                        it.setBridge(ref("bridge"))

                                } // END carouselSocket description
                     /*}*/  //For

                }.calls {
                    it.listens (ref("simuCarouselMotor"))
                    // simulation context only ? YES !
                    //for(int ix=0; ix< socketNumber ; ix++) {
                        it.listens(ref("clampXplus"), ref("clampXminus"))
                    //}
                }//end description of carousel's children
                //END Carousel description
                // ------------------------

                // ------------------------
                //BEGIN AUTO CHANGER
                autochanger (SftAutoChangerModule,
                        argMap( a("name", "autochanger"),
                                anInt("tickMillis",5000),
                                anInt("timeToConfortAPosition",2000),
                                anInt("timeToGoToStandby",10000),
                                anInt("timeToGoToStandback",10000),
                                anInt("timeoutForClosingLatches", 4000),
                                anInt("timeoutForOpeningLatches", 4000),
                                anInt("timeToWaitForCompleteClose", 2000),
                                anInt("timeToWaitForCompleteOpen", 2000),
                                aString("railsSensorsDIOName",railsSensorsDIOName,[description:"The name of the DIO where the rails sensors are plugged."]),
                                aString("filterSensorsDIOName",filterSensorsDIOName,[description:"The name of the DIO where the filter sensors are plugged."]),
                                ref("sftTrucksMotor"),
                                ref("latchXminus"),
                                ref("latchXplus"),
                                ref("truckXminus"),
                                ref("truckXplus")))
                        
                {//begin description of autochanger's children

                    // ------------------------
                    //BEGIN  SFT TRUCKS MOTOR (AUTOCHANGER)
                    sftTrucksMotor(anImpl(SftTruckMotor, SimuTruckMotorModule),
                            argMap( a("name","sftTrucksMotor"),
                                    anInt("tickMillis", 5000)))
         

                    //END  SFT TRUCKS MOTOR
                    // ------------------------



                    // ------------------------
                    //BEGIN  latchMinux    (AUTOCHANGER)
                    "latchXminus" (anImpl(FilterLatch, SimuFilterLatchModule),
                        argMap( a ("name", "latchXminus") ,
                                anInt("tickMillis", 5000),
                                //aBool("locked")
                                anInt("timeoutForClosing", 4000),
                                anInt("timeoutForOpening", 4000),
                                anInt("timeToWaitForCompleteClose", 2000),
                                anInt("timeToWaitForCompleteOpen", 2000),
                                aString("filterSensorsDIOName",filterSensorsDIOName,[static:true,description:"The name of the DIO where the filter sensors are plugged."]),
                                aRef("lockSensor","lockSensorLatchXminus"),
                                aRef("unlockSensor","unlockSensorLatchXminus"),
                                aRef("filterPresenceSensor","filterPresenceSensorLatchXminus"),
                                aRef("latchActuator","latchActuatorXminus")))
                        {
                            "lockSensorLatchXminus" ( anImpl( NumericSensor,SimuNumericSensor) ,
                                argMap(a ("name", "lockSensorLatchXminus") ,
                                    //aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))

                            "unlockSensorLatchXminus" ( anImpl( NumericSensor,SimuNumericSensor) ,
                                argMap( a("name", "unlockSensorLatchXminus"),
                                    //aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                            "filterPresenceSensorLatchXminus" ( anImpl( NumericSensor,SimuNumericSensor) ,
                                argMap( a("name", "filterPresenceSensorLatchXminus") ,
                                    //aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                    anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                            "latchActuatorXminus" (
                                    anImpl(Actuator, SimuLatchActuatorModule),
                                    argMap(a("name", "latchActuatorXminus") ,
                                            aString("filterSensorsDIOName",filterSensorsDIOName,[static:true,description:"The name of the DIO where the filter sensors are plugged."]),
                                                anInt("tickMillis", 3000),
                                                anInt("speedVoltageMaxValue", 10),
                                                anInt("speedVoltageMinValue", -10)))
                        }
                        // ------------------------
                        //END  latchXminus    (AUTOCHANGER)

                        // ------------------------
                        //BEGIN  latchXplus    (AUTOCHANGER)
                        "latchXplus" (anImpl(FilterLatch, SimuFilterLatchModule),
                                argMap( a ("name", "latchXplus") ,
                                        anInt("tickMillis", 5000),
                                        anInt("timeoutForClosing", 4000),
                                        anInt("timeoutForOpening", 4000),
                                        anInt("timeToWaitForCompleteClose", 2000),
                                        anInt("timeToWaitForCompleteOpen", 2000),
                                        aString("filterSensorsDIOName",filterSensorsDIOName,[static:true,description:"The name of the DIO where the filter sensors are plugged."]),
                                        aRef("lockSensor","lockSensorLatchXplus"),
                                        aRef("unlockSensor","unlockSensorLatchXplus"),
                                        aRef("filterPresenceSensor","filterPresenceSensorLatchXplus"),
                                        aRef("latchActuator","latchActuatorXplus")))

                                {
                                    "lockSensorLatchXplus" ( anImpl( NumericSensor,SimuNumericSensor) ,
                                        argMap(a ("name", "lockSensorLatchXplus") ,
                                            //aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                            anInt("inputNumero", 6, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                                    "unlockSensorLatchXplus" ( anImpl( NumericSensor,SimuNumericSensor) ,
                                            argMap( a("name", "unlockSensorLatchXplus"),
                                                //aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                                anInt("inputNumero", 7, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                                    "filterPresenceSensorLatchXplus" ( anImpl( NumericSensor,SimuNumericSensor) ,
                                            argMap( a("name", "filterPresenceSensorLatchXplus") ,
                                                //aString("dioName",filterSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                                anInt("inputNumero", 5, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."])))


                                    "latchActuatorXplus" (
                                            anImpl(Actuator, SimuLatchActuatorModule),
                                            argMap(a("name", "latchActuatorXplus") ,
                                                aString("filterSensorsDIOName",filterSensorsDIOName,[static:true,description:"The name of the DIO where the filter sensors are plugged."]),
                                                anInt("tickMillis", 3000),
                                                anInt("speedVoltageMaxValue", 10),
                                                anInt("speedVoltageMinValue", -10)))

                                }
                                //END  LATCH   (AUTOCHANGER)
                                // ------------------------

                        // ------------------------
                        //BEGIN  TRUCK   (AUTOCHANGER)
                        "truckXminus" (  SimuTruckModule ,
                            argMap(  a("name", "truckXminus") ,
                                        anInt("tickMillis", 3000),
                                        aRef("railSensorStandby", "railSensorStandbyXminus") ,
                                        aRef("railSensorStandback", "railSensorStandbackXminus") ))
                           {
                               "railSensorStandbyXminus" (  anImpl(NumericSensor, SimuNumericSensor) ,
                                    argMap( a("name", "railSensorStandbyXminus"),
                                        //aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                        anInt("inputNumero", 6 , [description:"The numero of the input of the DIO where this sensor is plugged."]) ))

                               "railSensorStandbackXminus" (  anImpl(NumericSensor , SimuNumericSensor) ,
                                       argMap( a("name", "railSensorStandbackXminus"),
                                           //aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                           anInt("inputNumero", 5, [description:"The numero of the input of the DIO where this sensor is plugged."]) ))
                           }

                        "truckXplus" (  SimuTruckModule ,
                            argMap(  a("name", "truckXplus") ,
                                    anInt("tickMillis", 3000),
                                    aRef("railSensorStandby", "railSensorStandbyXplus") ,
                                    aRef("railSensorStandback", "railSensorStandbackXplus") ))
                            {
                                "railSensorStandbyXplus" (  anImpl(NumericSensor, SimuNumericSensor) ,
                                        argMap( a("name", "railSensorStandbyXplus"),
                                            //aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                            anInt("inputNumero", 8, [description:"The numero of the input of the DIO where this sensor is plugged."] ) ))


                                "railSensorStandbackXplus" (  anImpl(NumericSensor , SimuNumericSensor) ,
                                        argMap( a("name", "railSensorStandbackXplus"),
                                            //aString("dioName",railsSensorsDIOName,[static:true,description:"The name of the DIO (Digital Input Output module) on which this sensor is plugged."]),
                                            anInt("inputNumero", 7, [description:"The numero of the input of the DIO where this sensor is plugged."]) ))

                            }
                        //END  TRUCK   (AUTOCHANGER)
                        // ------------------------


                }.calls {
                    it.listens(ref("sftTrucksMotor"))

                }
                //END AUTO CHANGER
                // ------------------------           

                "filterSensorsDIO" ( SimuCompactIOModule , 
                                            argMap(a("name", filterSensorsDIOName) ,
                                                anInt("tickMillis", 3000),
                                                aString("initialHexaValue", "44")))
                                        
                "railsSensorsDIO" ( SimuCompactIOModule , 
                                            argMap(a("name", railsSensorsDIOName) ,
                                                anInt("tickMillis", 3000),
                                                aString("initialHexaValue", "50")))
                
                
            //end description of Main submodules
            }.calls {
            it.listens (ref("carousel"), ref("autochanger"))
            }    // main ok

                


