/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.ClampActuatorModule;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.FilterLatchModule;
import org.lsst.ccs.subsystems.fcs.LatchActuatorModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLatch;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftCarouselModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftMainModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.ActuatorConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.ClampConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;

public class FcsUtils {
    public static SingleFilterTestConfig createSingleFilterTestConfig(SftMainModule main) {
        SftCarouselModule carouselModule = main.getCarouselModule();
        SftAutoChangerModule autochanger = main.getAutoChangerModule();
        return new SingleFilterTestConfig(FcsUtils.createClampConfig(carouselModule.getClampXminus()), FcsUtils.createClampConfig(carouselModule.getClampXplus()), FcsUtils.createActuatorConfig((ClampActuatorModule)carouselModule.getClampActuatorXminus()), FcsUtils.createActuatorConfig((ClampActuatorModule)carouselModule.getClampActuatorXplus()), FcsUtils.createActuatorConfig(autochanger.getLatchXminus().getLatchActuator()), FcsUtils.createActuatorConfig(autochanger.getLatchXplus().getLatchActuator()));
    }

    public static ClampConfig createClampConfig(FilterClampModule filterModule) {
        return new ClampConfig(filterModule.getName(), filterModule.getFilterPositionValueA(), filterModule.getFilterPositionValueB(), filterModule.getFilterPositionValueC(), filterModule.getLockSensorValueA(), filterModule.getLockSensorValueB(), filterModule.getLockSensorValueC(), filterModule.getFilterPositionMinValue(), filterModule.getFilterPositionMaxValue(), filterModule.getLockSensorMinValue(), filterModule.getLockSensorMaxValue());
    }

    public static ActuatorConfig createActuatorConfig(ClampActuatorModule actuatorModule) {
        return new ActuatorConfig(actuatorModule.getSentCurrentMinValue(), actuatorModule.getSentCurrentMaxValue());
    }

    public static ActuatorConfig createActuatorConfig(LatchActuatorModule actuatorModule) {
        return new ActuatorConfig(actuatorModule.getSpeedVoltageMinValue(), actuatorModule.getSpeedVoltageMaxValue());
    }

    public static StatusDataPublishedByBasicAutoChanger createStatusDataPublishedByBasicAutoChanger(BasicAutoChangerModule basicAutoChanger) {
        StatusDataPublishedByBasicAutoChanger status = new StatusDataPublishedByBasicAutoChanger();
        status.setName(basicAutoChanger.getName());
        status.setFilterOnTrucksName(basicAutoChanger.getFilterOnTrucksName());
        status.setTrucksEmpty(basicAutoChanger.isTrucksEmpty());
        status.setRailSensorStandbackXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandback().getDigitalValue());
        status.setRailSensorStandbackXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandback().getDigitalValue());
        status.setRailSensorStandbyXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandby().getDigitalValue());
        status.setRailSensorStandbyXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandby().getDigitalValue());
        status.setMovingToStandback(basicAutoChanger.isMovingToStandback());
        status.setMovingToStandby(basicAutoChanger.isMovingToStandby());
        return status;
    }

    public static StatusDataPublishedByAutoChanger createStatusDataPublishedByAutoChanger(AutoChangerModule autochanger) {
        StatusDataPublishedByAutoChanger status = new StatusDataPublishedByAutoChanger();
        status.setName(autochanger.getName());
        status.setFilterOnTrucksName(autochanger.getFilterOnTrucksName());
        status.setTrucksEmpty(autochanger.isTrucksEmpty());
        status.setTrucksLocation(autochanger.getTrucksLocation());
        status.setFilterOnTrucksName(autochanger.getFlipRailState().toString());
        status.setIsLockedOnlineClamp(autochanger.getOnlineClamp().isLocked());
        return status;
    }

    public static StatusDataPublishedByCarousel createStatusDataPublishedByCarousel(CarouselModule carousel) {
        int nbSockets = carousel.getNbSockets();
        StatusDataPublishedByCarousel status = new StatusDataPublishedByCarousel(nbSockets);
        status.setRotationInDegrees(carousel.getPosition());
        status.setIsLocked(carousel.isLocked());
        int i = 0;
        while (i < nbSockets) {
            status.setFilterName(i, carousel.getSockets()[i].getFilter() == null ? "empty" : carousel.getSockets()[i].getFilter().getName());
            StringBuilder sb = new StringBuilder("Socket number: ");
            sb.append(i).append("\n");
            sb.append(carousel.getSockets()[i].toString());
            status.setClampsInfo(i, sb.toString());
            ++i;
        }
        status.setFilterInStandbyName(carousel.getFilterInStandbyName());
        status.setActuatorXminusState(carousel.getClampActuatorXminus().toString());
        status.setActuatorXplusState(carousel.getClampActuatorXplus().toString());
        return status;
    }

    public static StatusDataPublishedByClamp createStatusDataPublishedByClamp(FilterClampModule clamp) {
        StatusDataPublishedByClamp status = new StatusDataPublishedByClamp();
        status.setName(clamp.getName());
        status.setClampState(clamp.getClampState().toString());
        status.setFilterPositionInClamp(clamp.getFilterPresenceStatus().toString());
        status.setFilterPositionSensorValue(clamp.getFilterPresenceSensor().getValue());
        status.setLockSensorValue(clamp.getLockSensor().getValue());
        status.setLockStatus(clamp.getLockStatus().toString());
        status.setTemperature(clamp.getTemperature());
        return status;
    }

    public static StatusDataPublishedByClampActuator createStatusDataPublishedByClampActuator(ClampActuatorModule actuator) {
        StatusDataPublishedByClampActuator status = new StatusDataPublishedByClampActuator();
        status.setName(actuator.getName());
        status.setReadValue(actuator.getReadValue());
        status.setSentValue(actuator.getSentValue());
        status.setOn(actuator.isOn());
        return status;
    }

    public static StatusDataPublishedByLatch createStatusDataPublishedByLatch(FilterLatchModule latch) {
        StatusDataPublishedByLatch status = new StatusDataPublishedByLatch();
        status.setName(latch.getName());
        status.setLockSensorValue(latch.getLockSensor().getDigitalValue());
        status.setUnlockSensorValue(latch.getUnlockSensor().getDigitalValue());
        status.setFilterPositionSensorValue(latch.getFilterPresenceSensor().getDigitalValue());
        status.setLockStatus(latch.getLockStatus().toString());
        return status;
    }
}

