/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.proxies.HardwareControlNotReady;
import org.lsst.ccs.subsystems.fcs.drivers.ApcTcpProxy;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.errors.ErrorInBootingHardwareProcessException;
import org.lsst.ccs.subsystems.fcs.errors.ProxyTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.ReadingADCException;

public class TestBenchMainModule
extends Module {
    private ApcTcpProxy tcpProxy;
    private String myClientName = "APCTestBench";
    private int nodeNB = 2;
    private int bootednodeNB = 0;
    private int infoNB = 0;
    private CanOpenNode[] nodes = new CanOpenNode[this.nodeNB];
    private boolean hardwareBooted = false;
    private boolean adcInitialized = false;
    private static double adcVoltsPerBit = 0.3125;
    private static double waterFreezeTemp = 273.15;

    public ApcTcpProxy getTcpProxy() {
        return this.tcpProxy;
    }

    public void setTcpProxy(ApcTcpProxy myTcpProxy) {
        this.tcpProxy = myTcpProxy;
    }

    public String getMyClientName() {
        return this.myClientName;
    }

    public void setMyClientName(String myClientName) {
        this.myClientName = myClientName;
    }

    public void initModule() {
        this.nodes = new CanOpenNode[this.nodeNB];
    }

    public void tick() {
        if (!this.hardwareBooted && this.tcpProxy.isReady(this.myClientName)) {
            try {
                this.bootHardware();
            }
            catch (ErrorInBootingHardwareProcessException ex) {
                Logger.getLogger(TestBenchMainModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.hardwareBooted && !this.adcInitialized) {
            try {
                this.initADC(1);
                this.adcInitialized = true;
                log.debug((Object)"ADC is initialized", new String[0]);
            }
            catch (ReadingADCException ex) {
                Logger.getLogger(TestBenchMainModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public int getReturnValue(String responseLine, int inputNB) throws ReadingADCException {
        if (inputNB < 1 || inputNB > 8) {
            throw new IllegalArgumentException();
        }
        String[] words = responseLine.split(",");
        log.debug((Object)("Value in HEXA:" + words[inputNB]), new String[0]);
        int value = Integer.parseInt(words[inputNB], 16);
        log.debug((Object)("Value in decimal:" + words[inputNB]), new String[0]);
        return value;
    }

    public double readTemperature() throws ReadingADCException {
        int value = this.getReturnValue(this.readADC(), 1);
        log.debug((Object)"Input Value read on the ADC:", new String[0]);
        double voltage = (double)value * adcVoltsPerBit;
        log.debug((Object)("Voltage = " + voltage + " volts"), new String[0]);
        double temperature = voltage / 10.0 - waterFreezeTemp;
        return temperature;
    }

    public String readADC() throws ReadingADCException {
        Object response = null;
        log.debug((Object)("Nom du client= " + this.myClientName), new String[0]);
        if (!this.tcpProxy.isReady(this.myClientName)) {
            throw new HardwareControlNotReady(this.myClientName);
        }
        response = this.getTcpProxy().call(this.myClientName, "adc,");
        if (response instanceof String) {
            log.debug((Object)("Reponse= " + response), new String[0]);
            return (String)response;
        }
        throw new ReadingADCException(response);
    }

    public String readFromSocket(String clientName) throws ProxyTimeoutException {
        String response = null;
        int timeout = 1000;
        response = this.tcpProxy.readFromSocket(clientName, timeout);
        log.debug((Object)("READ Reponse= " + response), new String[0]);
        return response;
    }

    public void turnOnLED() {
        if (!this.tcpProxy.isReady(this.myClientName)) {
            throw new HardwareControlNotReady(this.getMyClientName());
        }
        this.getTcpProxy().call(this.getMyClientName(), "dac,3000,0000,0000,0000");
    }

    public void turnOffLED() {
        if (!this.tcpProxy.isReady(this.myClientName)) {
            throw new HardwareControlNotReady(this.getMyClientName());
        }
        this.getTcpProxy().call(this.getMyClientName(), "dac,0,0,0,0");
    }

    public void stopAutomaticMode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void stop() {
        this.getTcpProxy().stop();
    }

    private void bootHardware() throws ErrorInBootingHardwareProcessException {
        while (this.bootednodeNB < this.nodeNB || this.infoNB < this.nodeNB) {
            try {
                int timeout = 1000;
                String bootLine = this.tcpProxy.readFromSocket(this.myClientName, timeout);
                String[] words = bootLine.split(",");
                String command = words[0];
                String nodeID = words[1];
                log.debug((Object)("Received on socket command = " + command + "," + nodeID), new String[0]);
                if (command.equals("boot")) {
                    this.nodes[this.bootednodeNB] = new CanOpenNode(nodeID);
                    ++this.bootednodeNB;
                    log.debug((Object)("Node " + nodeID + " added"), new String[0]);
                    log.debug((Object)("Hardware booted nb=" + this.bootednodeNB), new String[0]);
                    continue;
                }
                if (!command.equals("info")) continue;
                String type = words[2];
                String vendor = words[3];
                String productCode = words[4];
                String revision = words[5];
                String serialNB = words[6];
                this.addNodeInfo(nodeID, type, vendor, productCode, revision, serialNB);
                ++this.infoNB;
                log.debug((Object)("Node Info" + nodeID + " added"), new String[0]);
            }
            catch (ProxyTimeoutException ex) {
                Logger.getLogger(TestBenchMainModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void addNodeInfo(String nodeID, String type, String vendor, String productCode, String revision, String serialNB) throws ErrorInBootingHardwareProcessException {
        int i = 0;
        while (i < this.nodes.length) {
            if (this.nodes[i] != null && this.nodes[i].getNodeID().equals(nodeID)) {
                this.nodes[i].setNodeInfo(type, vendor, productCode, revision, serialNB);
            }
            ++i;
        }
    }

    public String listNodes() {
        StringBuilder sb = new StringBuilder("Nodes LIST = ");
        int i = 0;
        while (i < this.nodes.length) {
            sb.append("\n");
            sb.append(this.nodes[i].toString());
            ++i;
        }
        log.debug((Object)sb.toString(), new String[0]);
        return sb.toString();
    }

    private void initADC(int syncNB) throws ReadingADCException {
        Object ack = this.getTcpProxy().call(this.getMyClientName(), "wsdo,1,1801,2,1,1");
        if (!(ack instanceof String)) {
            throw new ReadingADCException(ack);
        }
        log.debug((Object)("initADC-step1 = " + ack), new String[0]);
        Object ack2 = this.getTcpProxy().call(this.getMyClientName(), "wsdo,1,1802,2,1,1");
        log.debug((Object)("initADC-step2 = " + ack2), new String[0]);
    }

    public Object sendCanOpen(String command) {
        return this.getTcpProxy().call(this.getMyClientName(), command);
    }
}

