/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;

public class BridgeForAPCTestBench
extends BridgeToCanOpenHardware {
    @Override
    public void initModule() {
        log.debug((Object)("INIT MODULE" + this.getName()), new String[0]);
        PieceOfHardware[] hardwareList = new PieceOfHardware[]{this.ai814, this.ao412};
        this.tcpProxy.hardwareList = hardwareList;
        int numberOfNodes = hardwareList.length;
        this.tcpProxy.setExpectedNodesNB(numberOfNodes);
        log.debug((Object)("Number of pieces of hardware expected =" + numberOfNodes), new String[0]);
        try {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
        }
        catch (DeploymentException ex) {
            log.error((Object)(String.valueOf(ex.getMessage()) + ": Could not load CanOpen Error Tables"), new String[0]);
            this.getSubsystem().updateState(State.InError, "Could not load CanOpen Error Tables");
        }
    }
}

