/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.Motor;
import org.lsst.ccs.subsystems.fcs.common.RunningWay;

public abstract class SimulatedMotor
extends Module
implements Motor {
    private String serialNumber;
    private double maximalVelocity;
    private double nominalVelocity;
    private double period = 0.0;
    private double position = 0.0;
    private double requiredPosition = 0.0;
    private RunningWay runningWay;
    private long lastcall = 0L;
    private long stateChangeTime = 0L;
    private EngineState engineState = EngineState.STOP;
    private String positionOutputName;
    private double maximalPosition = 0.0;
    private double minimalPosition = 0.0;

    @Override
    public synchronized EngineState getEngineState() {
        return this.engineState;
    }

    @Override
    public double getMaximalVelocity() {
        return this.maximalVelocity;
    }

    @Override
    public double getNominalVelocity() {
        return this.nominalVelocity;
    }

    @Override
    public double getPeriod() {
        return this.period;
    }

    @Override
    public double getPosition() {
        return this.position;
    }

    @Override
    public double getRequiredPosition() {
        return this.requiredPosition;
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public long getStateChangeTime() {
        return this.stateChangeTime;
    }

    @Override
    public synchronized void setEngineState(EngineState engineState) {
        this.engineState = engineState;
    }

    @Override
    public void setMaximalVelocity(double maximalVelocity) {
        this.maximalVelocity = maximalVelocity;
    }

    @Override
    public void setNominalVelocity(double nominalVelocity) {
        this.nominalVelocity = nominalVelocity;
    }

    @Override
    public void setPeriod(double d) {
        this.period = d;
    }

    public void setPosition(double position) {
        this.position = position;
    }

    @Override
    public void setRequiredPosition(double requiredPosition) {
        this.requiredPosition = requiredPosition;
    }

    @Override
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Override
    public void setStateChangeTime(long currentTimeMillis) {
        this.stateChangeTime = currentTimeMillis;
    }

    @Override
    public double getMaximalPosition() {
        return this.maximalPosition;
    }

    @Override
    public double getMinimalPosition() {
        return this.minimalPosition;
    }

    @Override
    public void setMaximalPosition(double p) {
        this.maximalPosition = p;
    }

    @Override
    public void setMinimalPosition(double p) {
        this.minimalPosition = p;
    }

    @Override
    public void stop() {
        this.engineState.stop(this);
    }

    public void initModule() {
        try {
            log.info((Object)(" Initializing the Module : " + this.getName()), new String[0]);
            log.info((Object)(String.valueOf(this.getName()) + ": Initial position= " + this.getPosition()), new String[0]);
        }
        catch (RuntimeException e) {
            log.fatal((Object)(String.valueOf(this.getName()) + "in ERROR: " + " Initialization failed for simulated motor module : " + e.getMessage()), new String[0]);
            throw e;
        }
    }

    @Override
    public void move(double displacement) {
        if (displacement > 0.0) {
            this.move(displacement, RunningWay.POSITIVE);
        } else {
            this.move(-displacement, RunningWay.NEGATIVE);
        }
    }

    @Override
    public void move(double displacement, RunningWay theRunningWay) {
        if (displacement < 0.0) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + "/ displacement must be positive : " + displacement);
        }
        this.runningWay = theRunningWay;
        double periodNeededForThisDisplacement = displacement / this.nominalVelocity * 1000.0;
        log.info((Object)(String.valueOf(this.getName()) + " displacement: " + displacement + " way: " + (Object)((Object)theRunningWay) + " period: " + periodNeededForThisDisplacement), new String[0]);
        this.engineState.go(this, periodNeededForThisDisplacement, theRunningWay);
    }

    public void tick() {
        try {
            long currenttime;
            this.lastcall = currenttime = System.currentTimeMillis();
            this.incrementPosition(this.engineState.computeDisplacement(this, this.tickMillis, this.runningWay));
        }
        catch (Exception e) {
            log.error((Object)e, new String[0]);
        }
    }

    @Override
    public void incrementPosition(double inc) {
        if (this.getPosition() + inc > this.maximalPosition || this.getPosition() + inc < this.minimalPosition) {
            throw new UnsupportedOperationException(String.valueOf(this.getName()) + " : displacement " + inc + " undoable for this simulated motor, it's going out of position range. ");
        }
        if (inc != 0.0) {
            this.setPosition(this.getPosition() + inc);
            log.info((Object)(String.valueOf(this.getName()) + ": position=" + this.getPosition()), new String[0]);
            this.setChanged();
            this.notifyObservers(new Module.ValueUpdate((Module)this, this.positionOutputName, (Object)this.getPosition()));
        }
    }
}

