/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuClampFilterPresenceSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuClampLockSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCompactIOModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuFilterClampModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;

public class SimuTruckMotorModule
extends SftTruckMotor {
    private SftAutoChangerModule autochanger;
    private SimuFilterClampModule clampXminus;
    private SimuFilterClampModule clampXplus;

    public void initModule() {
        this.autochanger = (SftAutoChangerModule)this.getModule("autochanger");
        this.clampXminus = (SimuFilterClampModule)this.getModule("clampXminus");
        this.clampXplus = (SimuFilterClampModule)this.getModule("clampXplus");
    }

    @Override
    public String moveToStandback() throws CanOpenException {
        if (this.autochanger.isAtStandby()) {
            this.setMovingToStandback(true);
            long timeToGo = this.autochanger.getTimeToGoToStandback();
            try {
                log.debug((Object)(String.valueOf(this.getName()) + ": Waiting for the motor to go to STANDBACK"), new String[0]);
                Thread.sleep(timeToGo);
            }
            catch (InterruptedException ex) {
                log.debug((Object)ex, new String[0]);
            }
            this.setMovingToStandback(false);
            SimuCompactIOModule simuRailsSensors = (SimuCompactIOModule)this.autochanger.getRailsSensorsDIO();
            simuRailsSensors.setHexaValue("50");
            SimuCompactIOModule simuFilterSensors = (SimuCompactIOModule)this.autochanger.getFilterSensorsDIO();
            if (this.autochanger.isTrucksEmpty()) {
                simuFilterSensors.simulateFilterPresenceInLatches("0");
            } else {
                ((SimuClampFilterPresenceSensor)this.clampXminus.getFilterPresenceSensor()).simulateNoFilter(this.clampXminus);
                ((SimuClampFilterPresenceSensor)this.clampXplus.getFilterPresenceSensor()).simulateNoFilter(this.clampXplus);
                log.debug((Object)"====> END OF moveToStandback", new String[0]);
            }
        }
        return "Trucks are At Standback.";
    }

    @Override
    public String moveToStandby() throws CanOpenException {
        if (this.autochanger.isAtStandback()) {
            this.setMovingToStandby(true);
            long timeToGo = this.autochanger.getTimeToGoToStandby();
            try {
                log.debug((Object)(String.valueOf(this.getName()) + ": Waiting for the motor to go to STANDBY"), new String[0]);
                Thread.sleep(timeToGo);
            }
            catch (InterruptedException ex) {
                log.debug((Object)ex, new String[0]);
            }
            this.setMovingToStandby(false);
            SimuCompactIOModule simuRailsSensor = (SimuCompactIOModule)this.autochanger.getRailsSensorsDIO();
            simuRailsSensor.setHexaValue("A0");
            SimuCompactIOModule simuFilterSensors = (SimuCompactIOModule)this.autochanger.getFilterSensorsDIO();
            if (this.autochanger.isTrucksEmpty()) {
                simuFilterSensors.simulateFilterPresenceInLatches("1");
            } else {
                ((SimuClampFilterPresenceSensor)this.clampXminus.getFilterPresenceSensor()).simulateFilterIsLockable(this.clampXminus);
                ((SimuClampFilterPresenceSensor)this.clampXplus.getFilterPresenceSensor()).simulateFilterIsLockable(this.clampXplus);
                ((SimuClampLockSensor)this.clampXminus.getLockSensor()).simulateClampIsLOCKED(this.clampXminus);
                ((SimuClampLockSensor)this.clampXplus.getLockSensor()).simulateClampIsLOCKED(this.clampXplus);
            }
        }
        return "Trucks are At Standby.";
    }

    @Override
    public String off() throws CanOpenException {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
        return "Trucks motor is OFF";
    }
}

