/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.LatchActuatorModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCompactIOModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuNumericSensor;

public class SimuLatchActuatorModule
extends LatchActuatorModule {
    SimuCompactIOModule simuDIO;
    String filterSensorsDIOName;

    public String getFilterSensorsDIOName() {
        return this.filterSensorsDIOName;
    }

    public void setFilterSensorsDIOName(String filterSensorsDIOName) {
        this.filterSensorsDIOName = filterSensorsDIOName;
    }

    public void initModule() {
        this.simuDIO = (SimuCompactIOModule)this.getModule(this.filterSensorsDIOName);
    }

    @Override
    public String open() throws BadCommandException, ErrorInCommandExecutionException {
        int unlockSensorInputNumero;
        int lockSensorInputNumero;
        if (this.getName().endsWith("Xminus")) {
            lockSensorInputNumero = ((SimuNumericSensor)this.getModule("lockSensorLatchXminus")).getInputNumero();
            unlockSensorInputNumero = ((SimuNumericSensor)this.getModule("unlockSensorLatchXminus")).getInputNumero();
        } else if (this.getName().endsWith("Xplus")) {
            lockSensorInputNumero = ((SimuNumericSensor)this.getModule("lockSensorLatchXplus")).getInputNumero();
            unlockSensorInputNumero = ((SimuNumericSensor)this.getModule("unlockSensorLatchXplus")).getInputNumero();
        } else {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " Can't retrieve the latch for which I work.");
        }
        this.simuDIO.replaceDigitalValues(lockSensorInputNumero, "0", unlockSensorInputNumero, "1");
        log.debug((Object)(String.valueOf(this.getName()) + " is OPEN"), new String[0]);
        return String.valueOf(this.getName()) + " is OPEN";
    }

    @Override
    public String close() throws BadCommandException, ErrorInCommandExecutionException {
        int unlockSensorInputNumero;
        int lockSensorInputNumero;
        if (this.getName().endsWith("Xminus")) {
            lockSensorInputNumero = ((SimuNumericSensor)this.getModule("lockSensorLatchXminus")).getInputNumero();
            unlockSensorInputNumero = ((SimuNumericSensor)this.getModule("unlockSensorLatchXminus")).getInputNumero();
        } else if (this.getName().endsWith("Xplus")) {
            lockSensorInputNumero = ((SimuNumericSensor)this.getModule("lockSensorLatchXplus")).getInputNumero();
            unlockSensorInputNumero = ((SimuNumericSensor)this.getModule("unlockSensorLatchXplus")).getInputNumero();
        } else {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " Can't retrieve the latch for which I work.");
        }
        this.simuDIO.replaceDigitalValues(lockSensorInputNumero, "1", unlockSensorInputNumero, "0");
        return String.valueOf(this.getName()) + " is CLOSED";
    }

    @Override
    public String powerOff() throws BadCommandException, ErrorInCommandExecutionException {
        return String.valueOf(this.getName()) + " is OFF";
    }
}

