/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Random;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.ClampActuatorModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuClampLockSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuFilterClampModule;

public class SimuClampActuatorModule
extends ClampActuatorModule {
    Random r = new Random();
    CarouselModule carousel;

    public void initModule() {
        this.on = false;
        this.carousel = (CarouselModule)this.getModule("carousel");
    }

    @Override
    public String on() throws BadCommandException, ErrorInCommandExecutionException {
        SimuFilterClampModule clamp;
        this.on = true;
        log.debug((Object)(String.valueOf(this.getName()) + "==========> ACTUATOR ON"), new String[0]);
        if (this.getName().contains("Xminus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXminus();
        } else if (this.getName().contains("Xplus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXplus();
        } else {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": unable to find the clamp to unlock.");
        }
        ((SimuClampLockSensor)clamp.getLockSensor()).simulateClampIsUNLOCKED(clamp);
        this.sentValue = 500;
        this.sendToStatus((Status)this.getStatusData());
        return String.valueOf(this.getName()) + " is turned ON.";
    }

    @Override
    public String off() throws BadCommandException, ErrorInCommandExecutionException {
        SimuFilterClampModule clamp;
        this.on = false;
        log.debug((Object)(String.valueOf(this.getName()) + "==========> ACTUATOR OFF"), new String[0]);
        if (this.getName().contains("Xminus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXminus();
        } else if (this.getName().contains("Xplus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXplus();
        } else {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": unable to find the clamp to unlock.");
        }
        ((SimuClampLockSensor)clamp.getLockSensor()).simulateClampIsLOCKED(clamp);
        this.sentValue = 0;
        this.sendToStatus((Status)this.getStatusData());
        return String.valueOf(this.getName()) + " is turned OFF.";
    }

    @Override
    public int getSentValue() {
        if (this.getSentCurrentMinValue() >= 0) {
            if (this.getSentCurrentMaxValue() > 0) {
                return this.r.nextInt(this.getSentCurrentMaxValue());
            }
            String msg = String.valueOf(this.getName()) + ": ERROR in getSentValue: getSentCurrentMaxValue() should be positive";
            throw new IllegalArgumentException(msg);
        }
        return (int)this.r.nextGaussian() * this.getSentCurrentMaxValue() / 2;
    }

    public void tick() {
    }

    @Override
    public String maintainUnclamped() throws BadCommandException, ErrorInCommandExecutionException {
        return String.valueOf(this.getName()) + "Maintaining Current";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.isOn()) {
            sb.append(" is ON");
        } else {
            sb.append(" is OFF");
        }
        return sb.toString();
    }

    @Override
    public int getMotor_continuousCurrentLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_maxSpeedInCurrentMode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getMotor_mode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_outputCurrentLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_polePairNumber() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_thermalTimeConstantWinding() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_type() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNodeID() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getPositionSensorType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSerialNB() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

