/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.proxies.HardwareControlNotReady;
import org.lsst.ccs.subsystems.fcs.drivers.CommandDispenser;
import org.lsst.ccs.utilities.beanutils.WrappedException;

abstract class FcsTcpProxy
extends Module {
    private int portNumber = 50000;
    private Subsystem subsystem;
    private ServerSocket serverSock;
    private Thread readerThread;
    private volatile boolean stopped = false;
    private ClientContext clientContext;
    private CommandDispenser commandDispenser;
    final Lock lock = new ReentrantLock();
    final Condition aClientIsConnected = this.lock.newCondition();

    FcsTcpProxy() {
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void initModule() {
        this.commandDispenser = new CommandDispenser();
        try {
            this.serverSock = new ServerSocket(this.portNumber);
            log.info((Object)("SERVER STARTED ON PORT:" + this.portNumber), new String[0]);
            System.out.println("SERVER STARTED ON PORT:" + this.portNumber);
        }
        catch (IOException e) {
            log.error((Object)"server not started", (Throwable)e, new String[0]);
            throw new WrappedException((Throwable)e);
        }
        try {
            log.info((Object)"WAITING FOR C-WRAPPER CLIENT...", new String[0]);
            log.debug((Object)"DEBUGGING", new String[0]);
            Socket sock = this.serverSock.accept();
            log.info((Object)("socket accept on " + this.portNumber), new String[0]);
            BufferedReader reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), "ISO-8859-1"), 256);
            String nameAndProtocol = reader.readLine();
            if (nameAndProtocol == null) {
                log.error((Object)(String.valueOf(this.getName()) + " : nameAndProtocol is null : that should not happen."), new String[0]);
            } else {
                String[] words = nameAndProtocol.split(" ");
                String cname = words[0];
                this.clientContext = new ClientContext(cname, sock, reader, sock.getOutputStream());
                log.info((Object)("REGISTERED : " + cname), new String[0]);
            }
        }
        catch (IOException e) {
            log.warn((Object)(" unexpected " + e), new String[0]);
        }
        this.startTheadReader();
    }

    public void shutdownNow() {
        super.shutdownNow();
        this.stop();
    }

    protected void startTheadReader() {
        Runnable readingFromTcpProxy = new Runnable(){

            @Override
            public void run() {
                while (!FcsTcpProxy.this.stopped) {
                    try {
                        String readline = ((FcsTcpProxy)FcsTcpProxy.this).clientContext.reader.readLine();
                        if (readline == null) {
                            log.error((Object)"nameAndProtocol is null : that should not happen.", new String[0]);
                            continue;
                        }
                        log.debug((Object)("message read from tcpProxy=" + readline), new String[0]);
                        if (readline.startsWith("emcy")) {
                            FcsTcpProxy.this.processEmcyMessage(readline);
                            continue;
                        }
                        if (readline.startsWith("Unknown")) {
                            FcsTcpProxy.this.processUnknownCommand(readline);
                            continue;
                        }
                        String[] words = readline.split(",");
                        String commandWord = words[0];
                        String nodeID = words[1];
                        if (commandWord.equals("boot")) {
                            log.info((Object)("boot command received for node: " + nodeID), new String[0]);
                            FcsTcpProxy.this.processBootMessage(nodeID);
                            continue;
                        }
                        String token = String.valueOf(commandWord) + nodeID;
                        token = readline.startsWith("sync") ? "sync" : String.valueOf(commandWord) + nodeID;
                        log.debug((Object)("Corresponding token=" + token), new String[0]);
                        if (FcsTcpProxy.this.commandDispenser.isTokenUsed(token)) {
                            log.debug((Object)("Response to a registred command:" + readline), new String[0]);
                            try {
                                FcsTcpProxy.this.commandDispenser.registerResponse(token, readline);
                            }
                            catch (Exception ex) {
                                log.error((Object)("Error in registering response to command :" + readline), ex.getCause(), new String[0]);
                            }
                            continue;
                        }
                        log.info((Object)("Unsynchronous message read from tcpProxy=" + readline), new String[0]);
                    }
                    catch (IOException iOException) {
                        log.error((Object)"Error in Thread reading from the tcp client.", new String[0]);
                    }
                }
            }
        };
        log.info((Object)"STARTING Thread reader", new String[0]);
        this.readerThread = new Thread(readingFromTcpProxy);
        this.readerThread.start();
    }

    public void stop() {
        this.stopped = true;
        this.readerThread.interrupt();
        try {
            this.serverSock.close();
            log.info((Object)"TCPIP SERVER STOPPED", new String[0]);
        }
        catch (IOException iOException) {
            System.out.println(String.valueOf(this.getName()) + " : stop method does not work properly when closing socket");
        }
        try {
            this.clientContext.reader.close();
            this.clientContext.writer.close();
            this.clientContext.socket.close();
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(this.getName()) + " : stop method does not work properly");
        }
    }

    public synchronized boolean isReady(String clientName) {
        if (clientName == null) {
            throw new IllegalArgumentException("Client name can't be null.");
        }
        if (this.clientContext == null || this.clientContext.clientName == null) {
            return false;
        }
        return this.clientContext.clientName.equals(clientName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call(String clientName, String command) throws TimeoutException {
        log.debug((Object)(" CALL :" + clientName + " " + command), new String[0]);
        if (this.clientContext == null) {
            throw new HardwareControlNotReady(clientName);
        }
        if (this.stopped) {
            throw new IllegalStateException("textTCP module stopped");
        }
        try {
            String sentCommand = String.valueOf(command) + "\r\u0000\n";
            this.clientContext.writer.write(sentCommand, 0, sentCommand.length());
            this.clientContext.writer.flush();
            if (!(command.startsWith("rsdo") || command.startsWith("wsdo") || command.startsWith("info") || command.startsWith("sync"))) {
                if (!command.startsWith("srtr")) return "asynchronous command sent:" + command;
            }
            String commandToken = this.commandDispenser.register(command);
            try {
                long timeout = 5 * this.tickMillis;
                String string = this.commandDispenser.getCommandResponse(commandToken, timeout);
                return string;
            }
            catch (TimeoutException timeoutException) {
                log.error((Object)(" ERROR in tcpProxy call method for command :" + command), new String[0]);
                throw new TimeoutException("TIMEOUT expired in tcpProxy call method for command :" + command);
            }
            finally {
                this.commandDispenser.remove(commandToken);
            }
        }
        catch (IOException e) {
            log.error((Object)" ERROR in tcpProxy call method", new String[0]);
            throw new WrappedException(" ERROR in tcpProxy call method " + clientName, (Throwable)e);
        }
    }

    abstract void processBootMessage(String var1);

    abstract void processEmcyMessage(String var1);

    abstract void processUnknownCommand(String var1);

    protected static class ClientContext {
        String clientName;
        BufferedReader reader;
        BufferedWriter writer;
        Socket socket;

        ClientContext(String name, Socket socket, BufferedReader reader, OutputStream os) {
            try {
                this.clientName = name;
                this.reader = reader;
                this.socket = socket;
                this.writer = new BufferedWriter(new OutputStreamWriter(os, "ISO-8859-1"), 256);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"context not started", (Throwable)e, new String[0]);
                throw new Error(e);
            }
        }
    }
}

