/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.concurrent.TimeoutException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenADC;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenClampActuatorModule;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDAC;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDIO;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

public class BridgeToCanOpenHardware
extends Module
implements BridgeToHardware {
    protected CanOpenProxy tcpProxy;
    private boolean hardwareInitialized = false;
    private boolean configurationChecked = false;
    protected CanOpenClampActuatorModule clampActuatorXminus;
    protected CanOpenClampActuatorModule clampActuatorXplus;
    protected CanOpenADC ai814;
    protected CanOpenDAC ao412;
    private CanOpenDIO dio8n1;
    private CanOpenDIO dio8n2;

    public CanOpenProxy getTcpProxy() {
        return this.tcpProxy;
    }

    public void setTcpProxy(CanOpenProxy tcpProxy) {
        this.tcpProxy = tcpProxy;
    }

    public CanOpenADC getAi814() {
        return this.ai814;
    }

    public void setAi814(CanOpenADC ai814) {
        this.ai814 = ai814;
    }

    public CanOpenDAC getAo412() {
        return this.ao412;
    }

    public void setAo412(CanOpenDAC ao412) {
        this.ao412 = ao412;
    }

    public CanOpenDIO getDio8n1() {
        return this.dio8n1;
    }

    public void setDio8n1(CanOpenDIO dio8n1) {
        this.dio8n1 = dio8n1;
    }

    public CanOpenDIO getDio8n2() {
        return this.dio8n2;
    }

    public void setDio8n2(CanOpenDIO dio8n2) {
        this.dio8n2 = dio8n2;
    }

    public CanOpenClampActuatorModule getClampActuatorXplus() {
        return this.clampActuatorXplus;
    }

    public void setClampActuatorXplus(CanOpenClampActuatorModule actuator) {
        this.clampActuatorXplus = actuator;
    }

    public CanOpenClampActuatorModule getClampActuatorXminus() {
        return this.clampActuatorXminus;
    }

    public void setClampActuatorXminus(CanOpenClampActuatorModule actuator) {
        this.clampActuatorXminus = actuator;
    }

    @Override
    public boolean isCWrapperConnected() {
        return this.tcpProxy.isReady(this.tcpProxy.getMyClientName());
    }

    @Override
    public boolean isHardwareReady() {
        return this.tcpProxy.isHardwareReady();
    }

    public void initModule() {
        log.info((Object)("INIT MODULE" + this.getName()), new String[0]);
        PieceOfHardware[] hardwareList = new PieceOfHardware[]{this.clampActuatorXminus, this.clampActuatorXplus, this.ai814, this.ao412, this.dio8n1, this.dio8n2};
        this.tcpProxy.hardwareList = hardwareList;
        int numberOfNodes = hardwareList.length;
        this.tcpProxy.setExpectedNodesNB(numberOfNodes);
        log.info((Object)("Number of pieces of hardware expected =" + numberOfNodes), new String[0]);
        try {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
        }
        catch (DeploymentException ex) {
            log.error((Object)(String.valueOf(ex.getMessage()) + ": Could not load CanOpen Error Tables"), new String[0]);
            this.getSubsystem().updateState(State.InError, "Could not load CanOpen Error Tables");
        }
    }

    public void shutdown() {
        this.tcpProxy.stop();
        this.getSubsystem().shutdown();
    }

    public Object sendCanOpen(String command) throws InterruptedException, TimeoutException, BadCommandException {
        return this.tcpProxy.sendCanOpen(command);
    }

    @Override
    public CanOpenProxy.PDOStorage readPDOs() throws HardwareException, BadCommandException {
        log.debug((Object)(String.valueOf(this.name) + "/readPDOS"), new String[0]);
        return this.tcpProxy.readPDOs();
    }

    public String toString() {
        return this.name;
    }
}

