/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.proxies.HardwareControlNotReady;
import org.lsst.ccs.subsystems.fcs.errors.ProxyTimeoutException;
import org.lsst.ccs.utilities.beanutils.WrappedException;
import org.lsst.ccs.utilities.dispatch.ASyncObserver;
import org.lsst.ccs.utilities.dispatch.ParallelObservable;

public class ApcTcpProxy
extends Module {
    private static Logger logger = Logger.getLogger((String)"lsst.ccs.subsystem");
    private int portNumber = 50000;
    private Subsystem subsystem;
    private ServerSocket serverSock;
    private Thread serverThread;
    private volatile boolean stopped;
    private ConcurrentHashMap<String, ClientContext> map = new ConcurrentHashMap();
    private ParallelObservable<ClientContext> observable = new ParallelObservable();

    protected ClientContext getContextFor(String clientName) {
        return this.map.get(clientName);
    }

    public void addObserver(ASyncObserver<ClientContext> observer) {
        this.observable.addObserver(observer);
    }

    public void removeObserver(ASyncObserver<ClientContext> observer) {
        this.observable.removeObserver(observer);
    }

    public void initModule() {
        try {
            this.serverSock = new ServerSocket(this.portNumber);
            logger.trace((Object)("SERVER STARTED :" + this.portNumber));
        }
        catch (IOException e) {
            logger.error((Object)"server not started", (Throwable)e);
            throw new WrappedException((Throwable)e);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (!ApcTcpProxy.this.stopped) {
                    try {
                        Socket sock = ApcTcpProxy.this.serverSock.accept();
                        logger.trace((Object)("accept on " + ApcTcpProxy.this.portNumber));
                        BufferedReader reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), "ISO-8859-1"), 256);
                        String nameAndProtocol = reader.readLine();
                        if (nameAndProtocol == null) {
                            logger.error((Object)"nameAndProtocol is null : that should not happen.");
                            continue;
                        }
                        String[] words = nameAndProtocol.split(" ");
                        String name = words[0];
                        ClientContext context = new ClientContext(name, sock, reader, sock.getOutputStream());
                        ApcTcpProxy.this.map.put(name, context);
                        ApcTcpProxy.this.observable.notifyObservers((Object)context);
                        logger.trace((Object)("REGISTERED : " + name));
                    }
                    catch (IOException e) {
                        logger.warn((Object)(" unexpected " + e));
                        if (ApcTcpProxy.this.stopped) continue;
                        logger.error((Object)"server in TcpProxy module : ", (Throwable)e);
                    }
                }
            }
        };
        this.serverThread = new Thread(runnable);
        this.serverThread.start();
    }

    public void stop() {
        this.stopped = true;
        this.serverThread.interrupt();
        Enumeration<ClientContext> enumeration = this.map.elements();
        while (enumeration.hasMoreElements()) {
            ClientContext context = enumeration.nextElement();
            try {
                context.reader.close();
                context.writer.close();
            }
            catch (Exception exception) {
                System.out.println("todo: ");
            }
        }
        try {
            Thread.currentThread().interrupt();
            this.getSubsystem().shutdown();
        }
        catch (Exception exc) {
            logger.error((Object)("todo: change this!!!" + exc));
        }
        Thread.currentThread().interrupt();
    }

    public boolean isReady(String clientName) {
        return this.map.get(clientName) != null;
    }

    public Object call(String clientName, String command) {
        ClientContext context = this.map.get(clientName);
        logger.trace((Object)(" CALL :" + clientName + " " + command));
        if (context == null) {
            throw new HardwareControlNotReady(clientName);
        }
        if (this.stopped) {
            throw new IllegalStateException("textTCP module stopped");
        }
        try {
            command = String.valueOf(command) + "\r\n";
            context.writer.write(command, 0, command.length());
            context.writer.flush();
            String response = context.reader.readLine();
            logger.trace((Object)("received response : " + response));
            return response;
        }
        catch (Exception e) {
            this.map.remove(clientName);
            throw new WrappedException(" --> removed " + clientName, (Throwable)e);
        }
    }

    public String readFromSocket(String clientName, int timeout) throws ProxyTimeoutException {
        ClientContext context = this.map.get(clientName);
        logger.trace((Object)(" READ :" + clientName + " "));
        if (context == null) {
            throw new HardwareControlNotReady(clientName);
        }
        if (this.stopped) {
            throw new IllegalStateException("textTCP module stopped");
        }
        try {
            context.socket.setSoTimeout(timeout);
            String response = context.reader.readLine();
            logger.trace((Object)("read from Socket : " + response));
            return response;
        }
        catch (SocketTimeoutException ex) {
            throw new ProxyTimeoutException(ex, timeout);
        }
        catch (Exception e) {
            this.map.remove(clientName);
            throw new WrappedException(" --> removed " + clientName, (Throwable)e);
        }
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    protected static class ClientContext {
        String clientName;
        BufferedReader reader;
        BufferedWriter writer;
        Socket socket;
        int token;

        ClientContext(String name, Socket socket, BufferedReader reader, OutputStream os) {
            try {
                this.reader = reader;
                this.socket = socket;
                this.writer = new BufferedWriter(new OutputStreamWriter(os, "ISO-8859-1"), 256);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"context not started", (Throwable)e);
                throw new Error(e);
            }
        }
    }
}

