/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.ArrayList;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LatchActuatorModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLatch;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class FilterLatchModule
extends MobileItemModule {
    private boolean filterEngaged;
    private boolean locked;
    private boolean unlocked;
    private boolean inError;
    private FcsEnumerations.FilterPresenceInLatchStatus presenceStatus;
    private FcsEnumerations.LockStatus lockStatus;
    LatchActuatorModule latchActuator;
    protected NumericSensor filterPresenceSensor;
    protected NumericSensor lockSensor;
    protected NumericSensor unlockSensor;
    CompactIOModule filterSensorsDIO;
    String filterSensorsDIOName;
    final Condition stateUpdated;
    protected volatile boolean updatingState;
    private long timeoutForOpening;
    private long timeoutForClosing;

    public FilterLatchModule() {
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
    }

    public LatchActuatorModule getLatchActuator() {
        return this.latchActuator;
    }

    public void setLatchActuator(LatchActuatorModule latchActuator) {
        this.latchActuator = latchActuator;
    }

    public NumericSensor getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public void setFilterPresenceSensor(NumericSensor filterPresenceSensor) {
        this.filterPresenceSensor = filterPresenceSensor;
    }

    public NumericSensor getLockSensor() {
        return this.lockSensor;
    }

    public void setLockSensor(NumericSensor lockSensor) {
        this.lockSensor = lockSensor;
    }

    public NumericSensor getUnlockSensor() {
        return this.unlockSensor;
    }

    public void setUnlockSensor(NumericSensor unlockSensor) {
        this.unlockSensor = unlockSensor;
    }

    public CompactIOModule getFilterSensorsDIO() {
        return this.filterSensorsDIO;
    }

    public void setFilterSensorsDIO(CompactIOModule filterSensorsDIO) {
        this.filterSensorsDIO = filterSensorsDIO;
    }

    public String getFilterSensorsDIOName() {
        return this.filterSensorsDIOName;
    }

    public void setFilterSensorsDIOName(String filterSensorsDIOName) {
        this.filterSensorsDIOName = filterSensorsDIOName;
    }

    public long getTimeoutForClosing() {
        return this.timeoutForClosing;
    }

    public void setTimeoutForClosing(long timeoutForClosing) {
        this.timeoutForClosing = timeoutForClosing;
    }

    public long getTimeoutForOpening() {
        return this.timeoutForOpening;
    }

    public void setTimeoutForOpening(long timeoutForOpening) {
        this.timeoutForOpening = timeoutForOpening;
    }

    public void initModule() {
        this.filterSensorsDIO = (CompactIOModule)this.getModule(this.filterSensorsDIOName);
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        this.presenceStatus = FcsEnumerations.FilterPresenceInLatchStatus.UNKNOWN;
        this.filterEngaged = false;
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPEN)) {
            return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
        }
        if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSE)) {
            return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
        }
        throw new IllegalArgumentException("Action on latch must be OPEN or CLOSE");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        this.filterSensorsDIO.updateValue();
        String filterSensorsHexaValue = this.filterSensorsDIO.getHexaValue();
        this.updateState(filterSensorsHexaValue);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPEN)) {
            this.latchActuator.open();
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSE)) {
            this.latchActuator.close();
        } else {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + "Action on latch must be OPEN or CLOSE");
        }
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.LockStatus getLockStatus() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setLockStatus(FcsEnumerations.LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.FilterPresenceInLatchStatus getPresenceStatus() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public StatusDataPublishedByLatch getStatusData() {
        StatusDataPublishedByLatch status = FcsUtils.createStatusDataPublishedByLatch(this);
        return status;
    }

    public String open() throws BadCommandException, ErrorInCommandExecutionException, HardwareException, Exception {
        this.updateStateWithSensorsToCheckIfActionIsCompleted();
        if (this.isUnlocked()) {
            return String.valueOf(this.getName()) + "is already OPEN";
        }
        CarouselModule carousel = (CarouselModule)this.environment.getComponentByName("carousel");
        if (!carousel.isHoldingFilterAtStandby()) {
            throw new BadCommandException(String.valueOf(this.getName()) + "CANNOT OPEN LATCH at STANDBY : CAROUSEL is NOT HOLDING THE FILTER");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.OPEN, this.timeoutForOpening);
        this.latchActuator.powerOff();
        return String.valueOf(this.getName()) + " is OPEN";
    }

    public String close() throws BadCommandException, ErrorInCommandExecutionException, HardwareException, Exception {
        this.updateStateWithSensorsToCheckIfActionIsCompleted();
        if (this.isLocked()) {
            return String.valueOf(this.getName()) + "is already CLOSED";
        }
        this.executeAction(FcsEnumerations.MobileItemAction.CLOSE, this.timeoutForClosing);
        this.latchActuator.powerOff();
        return String.valueOf(this.getName()) + " is CLOSED";
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public boolean isInError() {
        return this.inError;
    }

    public void updateState(String hexaValue) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.filterPresenceSensor.updateValue(hexaValue);
            this.lockSensor.updateValue(hexaValue);
            this.unlockSensor.updateValue(hexaValue);
            if (this.filterPresenceSensor.getDigitalValue() == 1) {
                this.filterEngaged = true;
                this.presenceStatus = FcsEnumerations.FilterPresenceInLatchStatus.ENGAGED;
            } else {
                this.filterEngaged = false;
                this.presenceStatus = FcsEnumerations.FilterPresenceInLatchStatus.NOFILTER;
            }
            this.locked = this.lockSensor.getDigitalValue() == 1;
            this.unlocked = this.unlockSensor.getDigitalValue() == 1;
            this.inError = this.locked && this.unlocked;
            this.lockStatus = this.inError ? FcsEnumerations.LockStatus.ERROR : (this.locked ? FcsEnumerations.LockStatus.LOCKED : (this.unlocked ? FcsEnumerations.LockStatus.UNLOCKED : FcsEnumerations.LockStatus.UNKNOWN));
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
        StatusDataPublishedByLatch status = this.getStatusData();
        this.sendToStatus((Status)status);
        this.publishTrendingData(status);
    }

    public void publishTrendingData(StatusDataPublishedByLatch status) {
        long timeStamp = System.currentTimeMillis();
        ArrayList<ValueNotification> trendingValues = new ArrayList<ValueNotification>();
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/lockStatus", (Object)status.getLockStatus(), timeStamp));
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/lockSensorValue", (Object)status.getLockSensorValue(), timeStamp));
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/unlockSensorValue", (Object)status.getUnlockSensorValue(), timeStamp));
        trendingValues.add(new ValueNotification(String.valueOf(this.getName()) + "/filterPositionSensorValue", (Object)status.getFilterPositionSensorValue(), timeStamp));
        this.publishData(trendingValues);
    }

    private static class LatchError
    extends Exception {
        FilterLatchModule latch;

        public LatchError(String string, FilterLatchModule aThis) {
            super(string);
            this.latch = aThis;
        }
    }
}

