/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterLatchModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.TruckModule;
import org.lsst.ccs.subsystems.fcs.common.AutoChanger;
import org.lsst.ccs.subsystems.fcs.common.FilterLocation;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.ClampsOrLatchesDisagreeException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public abstract class BasicAutoChangerModule
extends MobileItemModule
implements AutoChanger {
    private boolean trucksEmpty;
    Filter filterOnTrucks;
    Filter filterToGrab;
    protected CarouselModule carousel;
    FcsEnumerations.AutoChangerTrucksLocation trucksLocation;
    private FilterLatchModule latchXminus;
    private FilterLatchModule latchXplus;
    protected TruckModule truckXminus;
    protected TruckModule truckXplus;
    CompactIOModule railsSensorsDIO;
    CompactIOModule filterSensorsDIO;
    String railsSensorsDIOName;
    String filterSensorsDIOName;
    public static final String publishedByAutoChangerOutputName = "publishedByAutoChanger";
    protected volatile ModuleState state = ModuleState.HALTED;
    private volatile FcsEnumerations.FilterPresenceInLatchStatus presenceStatus;
    protected volatile FcsEnumerations.LockStatus latchesState;
    private boolean initialized = false;
    protected volatile boolean updatingLatches = false;
    protected volatile boolean closingLatches = false;
    protected volatile boolean openingLatches = false;
    private volatile boolean updatingTrucksLocation = false;
    final Condition stateUpdated = this.lock.newCondition();
    final Condition closeCompleted = this.lock.newCondition();
    final Condition openCompleted = this.lock.newCondition();
    final Condition trucksLocationUpdated = this.lock.newCondition();
    protected long timeoutForOpeningLatches;
    protected long timeoutForClosingLatches;
    protected long timeToWaitForCompleteClose;
    protected long timeToWaitForCompleteOpen;

    public CompactIOModule getRailsSensorsDIO() {
        return this.railsSensorsDIO;
    }

    public void setRailsSensorsDIO(CompactIOModule railsSensorsDIO) {
        this.railsSensorsDIO = railsSensorsDIO;
    }

    public CompactIOModule getFilterSensorsDIO() {
        return this.filterSensorsDIO;
    }

    public void setFilterSensorsDIO(CompactIOModule filterSensorsDIO) {
        this.filterSensorsDIO = filterSensorsDIO;
    }

    @Override
    public Filter getFilterOnTrucks() {
        return this.filterOnTrucks;
    }

    public ModuleState getState() {
        return this.state;
    }

    public void setState(ModuleState state) {
        this.state = state;
    }

    public FilterLatchModule getLatchXminus() {
        return this.latchXminus;
    }

    public void setLatchXminus(FilterLatchModule latchXminus) {
        this.latchXminus = latchXminus;
    }

    public FilterLatchModule getLatchXplus() {
        return this.latchXplus;
    }

    public void setLatchXplus(FilterLatchModule latchXplus) {
        this.latchXplus = latchXplus;
    }

    public TruckModule getTruckXminus() {
        return this.truckXminus;
    }

    public void setTruckXminus(TruckModule truckXminus) {
        this.truckXminus = truckXminus;
    }

    public TruckModule getTruckXplus() {
        return this.truckXplus;
    }

    public void setTruckXplus(TruckModule truckXplus) {
        this.truckXplus = truckXplus;
    }

    public boolean isTrucksEmpty() {
        return this.trucksEmpty;
    }

    public void setTrucksEmpty(boolean isEmpty) {
        this.trucksEmpty = isEmpty;
    }

    public void setFilterOnTrucks(Filter filterOnTrucks) {
        this.filterOnTrucks = filterOnTrucks;
    }

    public String getFilterOnTrucksName() {
        if (this.filterOnTrucks == null) {
            return "none";
        }
        return this.filterOnTrucks.getName();
    }

    public String getFilterSensorsDIOName() {
        return this.filterSensorsDIOName;
    }

    public void setFilterSensorsDIOName(String filterSensorsDIOName) {
        this.filterSensorsDIOName = filterSensorsDIOName;
    }

    public String getRailsSensorsDIOName() {
        return this.railsSensorsDIOName;
    }

    public void setRailsSensorsDIOName(String railsSensorsDIOName) {
        this.railsSensorsDIOName = railsSensorsDIOName;
    }

    public long getTimeToWaitForCompleteClose() {
        return this.timeToWaitForCompleteClose;
    }

    public void setTimeToWaitForCompleteClose(long timeToWaitForCompleteClose) {
        this.timeToWaitForCompleteClose = timeToWaitForCompleteClose;
    }

    public long getTimeToWaitForCompleteOpen() {
        return this.timeToWaitForCompleteOpen;
    }

    public void setTimeToWaitForCompleteOpen(long timeToWaitForCompleteOpen) {
        this.timeToWaitForCompleteOpen = timeToWaitForCompleteOpen;
    }

    public long getTimeoutForClosingLatches() {
        return this.timeoutForClosingLatches;
    }

    public void setTimeoutForClosingLatches(long timeoutForClosingLatches) {
        this.timeoutForClosingLatches = timeoutForClosingLatches;
    }

    public long getTimeoutForOpeningLatches() {
        return this.timeoutForOpeningLatches;
    }

    public void setTimeoutForOpeningLatches(long timeoutForOpeningLatches) {
        this.timeoutForOpeningLatches = timeoutForOpeningLatches;
    }

    public abstract boolean isMovingToStandback();

    public abstract boolean isMovingToStandby();

    public void initModule() {
        log.info((Object)"[AutoChangerModule] Initializing the Auto Changer module ", new String[0]);
        this.trucksLocation = FcsEnumerations.AutoChangerTrucksLocation.UNKNOWN;
        this.latchesState = FcsEnumerations.LockStatus.UNKNOWN;
        this.carousel = (CarouselModule)this.getModule("carousel");
        this.filterSensorsDIO = (CompactIOModule)this.getModule(this.filterSensorsDIOName);
        this.railsSensorsDIO = (CompactIOModule)this.getModule(this.railsSensorsDIOName);
        this.timeoutForClosingLatches = Math.max(this.latchXminus.getTimeoutForClosing(), this.latchXplus.getTimeoutForClosing());
        this.timeoutForOpeningLatches = Math.max(this.latchXminus.getTimeoutForOpening(), this.latchXplus.getTimeoutForOpening());
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        log.debug((Object)(String.valueOf(this.getName()) + "===> PROCESS_UPDATE from " + source.toString()), new String[0]);
        this.publishDataAndNotifyObservers();
    }

    public StatusDataPublishedByBasicAutoChanger getStatusData() {
        return FcsUtils.createStatusDataPublishedByBasicAutoChanger(this);
    }

    public void publishDataAndNotifyObservers() {
        StatusDataPublishedByBasicAutoChanger status = this.getStatusData();
        this.sendToStatus((Status)status);
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, publishedByAutoChangerOutputName, (Object)status));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n");
        sb.append("Trucks position = ");
        sb.append("Filter on trucks:");
        if (this.filterOnTrucks == null) {
            sb.append(" NONE").append("\n");
        } else {
            sb.append(this.filterOnTrucks.getName()).append("\n");
        }
        return sb.toString();
    }

    public abstract boolean isMoving();

    public abstract String goToStandby() throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException;

    public abstract String goToStandback() throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException;

    @Override
    public abstract String moveFilterToStandby(Filter var1) throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException;

    public abstract String moveFilterToStandback(Filter var1) throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException;

    public abstract void updateStateWithSensors() throws HardwareException, ErrorInCommandExecutionException;

    public void checkPreConditionsForTrucksMotion() throws BadCommandException, HardwareException, ErrorInCommandExecutionException {
        log.info((Object)"Checking pre-conditions for trucks motion", new String[0]);
        this.updateLatchesStateWithSensors();
        log.debug((Object)(String.valueOf(this.getName()) + " LATCHES STATUS= " + this.latchesState.toString()), new String[0]);
        if (this.latchesState == FcsEnumerations.LockStatus.ERROR) {
            throw new BadCommandException(String.valueOf(this.getName()) + "Trucks motion forbidden when latches are in ERROR.");
        }
        if (this.latchesState == FcsEnumerations.LockStatus.UNKNOWN) {
            throw new BadCommandException(String.valueOf(this.getName()) + "Trucks motion forbidden when latches status is in UNKNOWN.");
        }
        if (!this.trucksEmpty && this.latchesState == FcsEnumerations.LockStatus.UNLOCKED) {
            throw new BadCommandException(String.valueOf(this.getName()) + "Trucks motion forbidden when trucks are loaded and latches are UNLOCKED.");
        }
        log.info((Object)"===== Preconditions for trucks motion are checked.", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String grabFilterAtStandby(Filter filter) throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        if (this.filterOnTrucks != null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": can't grab a filter " + "when a filter is already loaded in trucks ");
        }
        log.info((Object)(String.valueOf(this.getName()) + ": grabbing " + filter.getName() + " at standby position."), new String[0]);
        this.goToStandby();
        this.closeLatchesAtStandby();
        BasicAutoChangerModule basicAutoChangerModule = this;
        synchronized (basicAutoChangerModule) {
            this.filterOnTrucks = filter;
            this.setTrucksEmpty(false);
            this.filterOnTrucks.setFilterLocation(FilterLocation.ONAUTOCHANGER);
        }
        String ack = String.valueOf(this.getName()) + ": " + filter.getName() + " is grabbed on autochanger";
        log.info((Object)ack, new String[0]);
        return ack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String ungrabFilterAtStandby() throws ErrorInCommandExecutionException, BadCommandException, HardwareException, CanOpenException {
        log.info((Object)(String.valueOf(this.getName()) + ": ungrabbing filter at standby position."), new String[0]);
        this.openLatchesAtStandby();
        BasicAutoChangerModule basicAutoChangerModule = this;
        synchronized (basicAutoChangerModule) {
            this.filterOnTrucks = null;
            this.setTrucksEmpty(true);
            this.publishDataAndNotifyObservers();
        }
        log.info((Object)(String.valueOf(this.getName()) + " trucks going empty to STANDBACK position"), new String[0]);
        this.goToStandback();
        String ack = String.valueOf(this.getName()) + ": trucks are empty at STANDBACK position ";
        return ack;
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.LockStatus getLatchesState() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isHoldingFilterAtStandby() {
        if (this.isMoving()) {
            return false;
        }
        if (!this.isAtStandby()) {
            return false;
        }
        if (this.isTrucksEmpty()) {
            return false;
        }
        return this.getLatchesState().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    public boolean isHoldingFilterAtStandback() {
        if (this.isMoving()) {
            return false;
        }
        if (!this.isAtStandback()) {
            return false;
        }
        if (this.isTrucksEmpty()) {
            return false;
        }
        return this.getLatchesState().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPENLATCHES)) {
            return this.getLatchesState().equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
        }
        if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSELATCHES)) {
            return this.getLatchesState().equals((Object)FcsEnumerations.LockStatus.LOCKED);
        }
        throw new IllegalArgumentException("Action on latches must be OPENLATCHES or CLOSELATCHES");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPENLATCHES)) {
            this.latchXminus.latchActuator.open();
            this.latchXplus.latchActuator.open();
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSELATCHES)) {
            this.latchXminus.latchActuator.close();
            this.latchXplus.latchActuator.close();
        } else {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + "Action on latches must be OPENLATCHES or CLOSELATCHES");
        }
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws HardwareException, ErrorInCommandExecutionException {
        try {
            this.updateLatchesStateWithSensors();
        }
        catch (ClampsOrLatchesDisagreeException clampsOrLatchesDisagreeException) {
            log.debug((Object)(String.valueOf(this.getName()) + ": a little delai between the update of the 2 latches : have to wait ..."), new String[0]);
        }
    }

    @Override
    public String openLatchesAtStandby() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        this.updateStateWithSensors();
        if (!this.isAtStandby()) {
            throw new BadCommandException(String.valueOf(this.getName()) + "CANNOT OPEN LATCHES at STANDBY : AUTOCHANGER is NOT AT STANDBY");
        }
        if (!this.carousel.isHoldingFilterAtStandby()) {
            throw new BadCommandException(String.valueOf(this.getName()) + "CANNOT OPEN LATCHES at STANDBY : CAROUSEL is NOT HOLDING THE FILTER");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.OPENLATCHES, this.timeoutForOpeningLatches);
        this.latchXminus.latchActuator.powerOff();
        this.latchXplus.latchActuator.powerOff();
        this.publishDataAndNotifyObservers();
        return "Autochanger latches are unlocked";
    }

    @Override
    public String closeLatchesAtStandby() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        this.updateStateWithSensors();
        if (!this.isAtStandby()) {
            throw new BadCommandException(String.valueOf(this.getName()) + "CANNOT CLOSE LATCHES at STANDBY : AUTOCHANGER is NOT AT STANDBY");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.CLOSELATCHES, this.timeoutForClosingLatches);
        this.latchXminus.latchActuator.powerOff();
        this.latchXplus.latchActuator.powerOff();
        this.publishDataAndNotifyObservers();
        return "Autochanger latches are locked";
    }

    public void updateLatchesStateWithSensors() throws HardwareException, ErrorInCommandExecutionException {
        this.lock.lock();
        this.updatingLatches = true;
        try {
            this.filterSensorsDIO.updateValue();
            String filterSensorsHexaValue = this.filterSensorsDIO.getHexaValue();
            this.latchXminus.updateState(filterSensorsHexaValue);
            this.latchXplus.updateState(filterSensorsHexaValue);
            if (!this.latchXminus.getLockStatus().equals((Object)this.latchXplus.getLockStatus())) {
                throw new ClampsOrLatchesDisagreeException("Error in latches lock status : the latches don't agree.", this.getName());
            }
            this.latchesState = this.latchXminus.getLockStatus();
            if (!this.latchXminus.getPresenceStatus().equals((Object)this.latchXplus.getPresenceStatus())) {
                throw new ClampsOrLatchesDisagreeException("Error in latches filter presence status : the latches don't agree.", this.getName());
            }
            this.presenceStatus = this.latchXminus.getPresenceStatus();
            this.trucksEmpty = !this.latchesState.equals((Object)FcsEnumerations.LockStatus.LOCKED) || !this.presenceStatus.equals((Object)FcsEnumerations.FilterPresenceInLatchStatus.ENGAGED);
            log.info((Object)(String.valueOf(this.getName()) + ": latches are updated"), new String[0]);
        }
        finally {
            this.updatingLatches = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
        this.publishDataAndNotifyObservers();
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.AutoChangerTrucksLocation getTrucksLocation() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isAtStandby() {
        return this.getTrucksLocation() == FcsEnumerations.AutoChangerTrucksLocation.STANDBY;
    }

    public boolean isAtStandback() {
        return this.getTrucksLocation() == FcsEnumerations.AutoChangerTrucksLocation.STANDBACK;
    }

    public void updateTrucksLocationWithSensors() throws ErrorInCommandExecutionException {
        block4: {
            this.lock.lock();
            this.updatingTrucksLocation = false;
            try {
                this.railsSensorsDIO.updateValue();
                String dioHexaValue = this.railsSensorsDIO.getHexaValue();
                log.debug((Object)(String.valueOf(this.railsSensorsDIO.getName()) + " HEXA VALUE=" + dioHexaValue), new String[0]);
                this.truckXminus.updateLocation(dioHexaValue);
                this.truckXplus.updateLocation(dioHexaValue);
                if (this.truckXminus.getTruckLocation() == this.truckXplus.getTruckLocation()) {
                    this.trucksLocation = this.truckXminus.getTruckLocation();
                    break block4;
                }
                String msg = String.valueOf(this.getName()) + "Trucks are not at the same location";
                log.error((Object)msg, new String[0]);
                throw new ErrorInCommandExecutionException(msg);
            }
            finally {
                this.updatingTrucksLocation = false;
                this.trucksLocationUpdated.signal();
                this.lock.unlock();
            }
        }
        this.publishDataAndNotifyObservers();
    }
}

