/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.drivers.PlutoSensor;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;


/**
 *
 * @author virieux
 */
public class CPPMTestBenchMainModule extends Module {

    BridgeToHardware bridge;
    CanOpenDevice plutoGateway;

    public CPPMTestBenchMainModule(BridgeToHardware bridge, CanOpenDevice plutoGateway) {
        this.bridge = bridge;
        this.plutoGateway = plutoGateway;
    }
    
    
      
    public String readSensors() throws HardwareException {
        String hexaValue = this.plutoGateway.readSDO("6004", "03");
        
        String bin = Integer.toBinaryString(Integer.parseInt(hexaValue, 16));
        
        System.out.println(bin);
        return bin;
    }
    
}
