/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;
import org.lsst.ccs.subsystems.fcs.errors.DeploymentException;

/**
 * This is the bridge to the can open hardware in the APC testbench.
 * @author virieux
 */
public class BridgeForAPCTestBench extends BridgeToCanOpenHardware {
    
    @Override
    public void initModule() {
        
        log.debug("INIT MODULE" + getName());
        
        PieceOfHardware[] hardwareList = {ai814, ao412};        
        tcpProxy.hardwareList = hardwareList;
        int numberOfNodes = hardwareList.length;
        tcpProxy.setExpectedNodesNB(numberOfNodes);
        log.debug("Number of pieces of hardware expected =" + numberOfNodes);
        
        
        //we have to read the errors table for the maxon motor and can open devices.
        try {
            CanOpenErrorsTable.loadDeviceErrorTable();
            CanOpenErrorsTable.loadErrorRegisterTable();
            CanOpenErrorsTable.loadCommunicationErrorTable();
        } catch (DeploymentException ex) {
            log.error(ex.getMessage() + ": Could not load CanOpen Error Tables");
            this.getSubsystem().updateState(State.InError, "Could not load CanOpen Error Tables");
        }
    }
    
}
