/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftCarouselModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftMainModule;

/**
 *
 * @author virieux
 */
public class SimuSftCarouselModule extends SftCarouselModule {
    
    @Override
    public void updateStateWithSensors() throws BadCommandException, HardwareException {
                if (this.getSocketAtStandby() == null) {
            throw new BadCommandException("Unable to read sensors when there is no socket at standby.");
        }
        this.getSocketAtStandby().updateClampsStateWithSensorsFromSDO();
        
        Filter dummyFilter = ((SftMainModule) this.getModule("main")).getDummyFilter();
        if (this.getSocketAtStandby().isClampedOnFilter() 
                || this.getSocketAtStandby().isUnclampedOnFilter()) {
            this.getSocketAtStandby().putFilterOnSocket(dummyFilter);
        } else {
            if (!(this.getSocketAtStandby().getFilter() == null)) {
                //this can happen only in engineering mode when we move the mechanic step by step
                this.getSocketAtStandby().removeFilter();
            }
        }
    }
    
    @Override
    public void updateClampsStateWithSensors() throws BadCommandException, HardwareException {
        updateClampsStateWithSensorsFromSDO();
    }
    
}
