/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.NumericSensor;

/**
 * This class is used in the single filter test to simulate the rail sensors of the autochanger
 * and the filter presence sensor on the lachtes.
 * The simulated rail sensors listen to the motors and update their digitalValue when the motor are 
 * set on or off (cf SimuActuatorModule).
 * 
 * To simulate the hardware we have in the Exchanger, a SimuNumericSensor is supposed to be attached 
 * to a simulated IO Module (simuIOModule).
 * This IO Module gives the values for 8 sensors in a hexa decimal format.
 * A sensor has an inputNumero on this IO Module to retrieve its values.
 * 
 * @author virieux
 */
public class SimuNumericSensor extends NumericSensor {
    
    CarouselModule carousel;
    Filter dummyFilter;

    int inputNumero;
    
    
    //FOR SPRING
    public Filter getDummyFilter() {
        return dummyFilter;
    }

    //FOR SPRING
    public void setDummyFilter(Filter dummyFilter) {
        this.dummyFilter = dummyFilter;
    }

    public int getInputNumero() {
        return inputNumero;
    }

    public void setInputNumero(int inputNumero) {
        this.inputNumero = inputNumero;
    }

    
    
    
    @Override
    public void initModule() {
        carousel = (CarouselModule) this.getModule("carousel");
    }
    
    

    public int readNewValue() {
        return this.digitalValue;
    }
    


    /**
     * This methods updates the digital value for this sensor.
     * It takes as an argument the value in hexa sent by the CompactIOModule.
     * This hexa value represents the 8 values for the 8 channels.
     * To retrieve the value for this sensor, the hexa value is transformed in binary, 
     * then reverse and the digital value is the digit at the index= inputNumero.
     * exmaple if hex = 80, and inputNumero=8, digital value=1 otherwise digital value=0.
     * @param hex 
     * TODO : this method is the copy of the NumericSensor's updateValue method. It should be put up in NumericSensor.
     */
    @Override
    public synchronized void updateValue(String hex) {
        //log.debug(Thread.currentThread().toString());
        //log.debug(getName() + " INPUT NO=" + inputNumero);
        
        String bin = Integer.toBinaryString(Integer.parseInt(hex, 16));
        
        //to add leading zeros on the left
        String s = String.format("%08d", Integer.parseInt(bin));
        //log.debug("binary value=" + s);
        
        //to retrieve the digital value for this sensor
        //(the digits are given from left to right
        //1010000 => DIO[8]=1,DIO[7]=0,DIO[6]=1,DIO[5]=0,DIO[4]=0,DIO[3]=0,DIO[2]=0,DIO[1]=0
        int myValue = Character.digit(s.charAt(8-inputNumero), 16);
        //log.debug(getName() + " Value updated=" + myValue);

        this.digitalValue = myValue;
    }
    
}
