/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Random;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.ClampActuatorModule;

/**
 *
 * @author virieux
 */
public class SimuClampActuatorModule extends ClampActuatorModule {

    Random r = new Random();
    
    CarouselModule carousel;

    @Override
    public void initModule() {
        this.on = false;
        this.carousel = (CarouselModule) this.getModule("carousel");
    }

    @Override
    public String on() throws BadCommandException, ErrorInCommandExecutionException {
        on = true;
        
        log.debug(getName() + "==========> ACTUATOR ON");

        //the clamp is now UNLOCKED : we have to simulate that.
        SimuFilterClampModule clamp;
        if (getName().contains("Xminus")) {
            clamp = (SimuFilterClampModule) this.carousel.getClampXminus();            
        } else if (getName().contains("Xplus")){
            clamp = (SimuFilterClampModule) this.carousel.getClampXplus();
        } else throw new ErrorInCommandExecutionException(getName() + ": unable to find the clamp to unlock.");
        ((SimuClampLockSensor) clamp.getLockSensor()).simulateClampIsUNLOCKED(clamp);
        
        //we have to publish on status bus the sentValue (for the GUI)
        this.sentValue = 500;
        this.sendToStatus(this.getStatusData());
        
        return getName() + " is turned ON.";
    }

    @Override
    public String off() throws BadCommandException, ErrorInCommandExecutionException {
        on = false;
        log.debug(getName() + "==========> ACTUATOR OFF");
        //the clamp is now LOCKED : we have to simulate that.
        SimuFilterClampModule clamp;
        if (getName().contains("Xminus")) {
            clamp = (SimuFilterClampModule) this.carousel.getClampXminus();            
        } else if (getName().contains("Xplus")){
            clamp = (SimuFilterClampModule) this.carousel.getClampXplus();
        } else throw new ErrorInCommandExecutionException(getName() + ": unable to find the clamp to unlock.");
        ((SimuClampLockSensor) clamp.getLockSensor()).simulateClampIsLOCKED(clamp);

        this.sentValue = 0;
        this.sendToStatus(this.getStatusData());
        return getName() + " is turned OFF.";
    }

    public int getSentValue() {
//        if (isOn()) {
            if (getSentCurrentMinValue() >= 0) {
                
                if (getSentCurrentMaxValue() > 0) {
                    return r.nextInt(getSentCurrentMaxValue());
                } else {
                    String msg = getName() + ": ERROR in getSentValue: getSentCurrentMaxValue() should be positive";
                    throw new IllegalArgumentException(msg);
                }
            }
            return (int) (r.nextGaussian()) * getSentCurrentMaxValue() / 2;
//        }
//        return 0;
    }

    @Override
    public void tick() {
        //this.sendToStatus(this.getStatusData());
    }

    @Override
    public String maintainUnclamped() throws BadCommandException, ErrorInCommandExecutionException {
        return getName() + "Maintaining Current";
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(getName());
        if (isOn()) {
            sb.append(" is ON");
        } else {
            sb.append(" is OFF");
        }
        return sb.toString();
    }

    @Override
    public int getMotor_continuousCurrentLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_maxSpeedInCurrentMode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getMotor_mode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_outputCurrentLimit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_polePairNumber() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_thermalTimeConstantWinding() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMotor_type() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNodeID() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getPositionSensorType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSerialNB() {
        throw new UnsupportedOperationException("Not supported yet.");
    }


}
