package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.CarouselModule;


public class SimuCarouselMotor extends SimulatedMotor {
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -9112408155838106760L;
	
	private final String positionOutputName = "carousel position";
	
	
	public SimuCarouselMotor () {
            super();
	}

	/**
         * There is no minimal or maximal position for the carousel.
         * @param inc
         */
	public void incrementPosition(final double inc) {
		
                if (!(inc == 0)) {
                    setPosition(CarouselModule.addAngle(getPosition(), inc));
                    setChanged();
                    notifyObservers(new ValueUpdate(positionOutputName, getPosition()));
                }
		
	}
}
