package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.common.Motor;
import org.lsst.ccs.subsystems.fcs.common.EngineState;
import org.lsst.ccs.subsystems.fcs.common.RunningWay;

/**
 * This is the concrete state where we know what to be done when the engine is
 * in the state "error".
 * It can only go in state "stop" when asked. It can't move.
 * 
 * @author colley, virieux
 * 
 */
public class ErrorState implements EngineState {

	public double computeDisplacement(Motor motor, double period,
			RunningWay runningWay) {
		return 0;
	}

	public String error(Motor m) {
		return m.getName() + ": going in state " + this.toString();
	}

	public String go(Motor m, double t, RunningWay runningWay) {
		return null;
	}

	public String stop(Motor motor) {
		motor.setStateChangeTime(System.currentTimeMillis());
		motor.setEngineState(STOP);
		return motor.getName() + ": [ErrorState] Motor stopping";
	}

	@Override
	public String toString() {
		return "ERROR";
	}

}
