/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

/**
 * This exception is throwned when a read SDO command returns an error code.
 * @author virieux
 */
public class SDORequestException extends CanOpenException {
    
    String subindex;
    String errorName;

    /**
     * Creates a new instance of <code>SDORequestError</code> without detail message.
     */
    public SDORequestException() {
    }

    /**
     * Constructs an instance of <code>SDORequestError</code> with the specified detail message.
     * @param msg the detail message.
     */
    public SDORequestException(String msg) {
        super(msg);
    }
    
    public SDORequestException(String msg, String nodeID, String errorCode, String index, String subindex, String errorName) {
        super(msg,nodeID,errorCode);
        this.subindex = subindex;
        this.errorName = errorName;
    }
    
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" subindex="); sb.append(subindex);
        sb.append(" error name="); sb.append(errorName);
        return sb.toString();
    }
}
