/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

/**
 * This exception is thrown when we can't detect a given Serial Number
 * on the Can Open network.
 * @author virieux
 */
public class HardwareNotDetectedException extends HardwareException {
    String nodeID;
    String serialNumber;
    /**
     * Creates a new instance of <code>HardwareNotDetectedException</code> without detail message.
     */
    public HardwareNotDetectedException() {
        super();
    }

    /**
     * Constructs an instance of <code>HardwareNotDetectedException</code> with the specified detail message.
     * @param msg the detail message.
     */
    public HardwareNotDetectedException(String msg) {
        super(msg);
    }

    public HardwareNotDetectedException(String msg, String name, String nodeID, String serialNumber) {
        super(msg, name);
        this.nodeID = nodeID;
        this.serialNumber = serialNumber;
    }
    

    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/");
        sb.append(hardwareName).append(" is UNREACHABLE.");
        sb.append(" [node id =").append(nodeID);
        sb.append(" serial NB=").append(serialNumber).append("]");
        return sb.toString();
    }
}
