/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.Thermometer;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy.PDOStorage;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

/**
 *
 * @author virieux
 */
public class CanOpenThermometer extends CanOpenSensor14bits implements Thermometer {

    /**
     * This methods translate the hexa value return by a sensor to the double value.
     * @param valueInHexa
     * @return the corresponding double value
     */
    public static double getDoubleValue(String valueInHexa) {
        double temp = 0;
        log.debug("Value in HEXA=" + valueInHexa);
            int valueInt = Integer.parseInt(valueInHexa, 16);
            double voltage = valueInt * CanOpenADC.adcVoltsPerBit;
            log.debug("Input Value read on the ADC:" + valueInt);
            log.debug("Voltage = " + voltage + " volts");
            temp = (voltage / 10) - CanOpenADC.waterFreezeTemp;
            return temp;
    }
    
    @Override
    public double readTemperature() throws HardwareException {
            String hexa = adc.readAnalogInput(numOfAnalogInput);
            return getDoubleValue(hexa);

    }

    @Override
    public double readTemperatureWithPDO(PDOStorage pdo) throws BadCommandException {
        
        if (!this.adc.isInitalized()) throw new BadCommandException("Can't read temperature from PDO if Can Open device is not initialized.");
        
        if (!this.adc.transmissionType.equals("1")) throw new BadCommandException("Transmission type for Can Open device must be 1");
        
        String hexa = pdo.getVarValue(this.adc.nodeID, Integer.toString(this.numOfAnalogInput));
        return getDoubleValue(hexa);
    }
    
}
