/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 *
 * @author virieux
 */
public class CanOpenDevice extends Module implements PieceOfHardware{
    
    CanOpenProxy tcpProxy;
    
    String serialNB;
    String nodeID;
    boolean initialized;
    
    //for SPRING
    public CanOpenDevice() {       
    }

    public CanOpenDevice(String serialNB, String nodeID) {
        this.tcpProxy = (CanOpenProxy) this.getModule("tcpProxy");
        this.serialNB = serialNB;
        this.nodeID = nodeID;
        this.initialized = false;
    }
    


    @Override
    public String getSerialNB() {
        return this.serialNB;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    public void setSerialNB(String serialNB) {
        this.serialNB = serialNB;
    }
    
    
    @Override
    public boolean isNodeIdBootedAndOK() {
        return tcpProxy.isNodeIdBootedAndOK(this);
    }

    @Override
    public boolean isInitalized() {
        return this.initialized;
    }
    
    @Override
    public void initModule() {
        tcpProxy = (CanOpenProxy) this.getModule("tcpProxy");
    }

    /**
     * This methods has to be overridden if there is some initialization to do for the device.
     * @return a message
     * @throws Exception 
     */
    @Override
    public String initializeHardware() throws Exception {
        this.initialized = true;
        return getName() + ": no hardware initialization for this device to be done.";
    }
    
    public String writeSDO(String index, String subindex,String length, String newValue) throws SDORequestException {
        return tcpProxy.writeSDO(this.nodeID,index,subindex,length,newValue);
    }
    
    public String readSDO(String index, String subindex) throws SDORequestException {
        return tcpProxy.readSDO(this.nodeID, index, subindex);
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(getName());
        sb.append("/");
        sb.append(this.serialNB);
        sb.append("/NodeID_in_hexa=");
        sb.append(this.nodeID);
        int x = Integer.parseInt(this.nodeID,16);
        sb.append("/NodeID_in_decimal=");sb.append(x);sb.append("/");
        // because the configuration system can call toString before the object is completely built
        // for tracing purpose.
        if (tcpProxy == null ) return sb.toString();
        if (isNodeIdBootedAndOK())  {
            sb.append("is booted/");
            
        } else {
            sb.append("ERROR/");
        }       
        return sb.toString();
    }
}
