/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;

/**
 * 
 * This is the driver class for the ADC we use in the FCS test bench and in SINGLE FILTER TEST
 * CAN-CBX-AI814
 * 
 * @author virieux
 */
//public class CanOpenADC extends Module implements PieceOfHardware {
public class CanOpenADC extends CanOpenDevice {
    


    /**
    * One bit read on the input of the ADC represents 0.3125 mV
    */
    public static final double adcVoltsPerBit = 0.3125;
    public static final double waterFreezeTemp = 273.15;
    
    
    /**
     * The transmission types for the analogue inputs are described in the following:
     *	acyclic, synchronous: The transmission is initiated if a SYNC-message has been received (PDO- transmission type 0) and data has changed.
     *	cyclic, synchronous: The transmission is initiated if a defined number of SYNC-messages have been received (PDO-transmission type 1...240).
     *	synchronous, remote request: The state of the inputs is latched with each SYNC-message and is transmitted after the reception of a RTR-frame (PDO-transmission type 252).
     *	asynchronous, remote request: After the reception of a RTR-frame the last latched state of the inputs is transmitted (PDO-transmission type 253).
     *  event controlled, asynchronous: The transmission is initiated if the state of selected inputs has changed (PDO-transmission type 254, 255).
     */
    String transmissionType;
    
    //FOR SPRING
    public CanOpenADC() {       
    }

//    public CanOpenADC(String nodeID, String serial) {
//        this.tcpProxy = (CanOpenProxy) this.getModule("tcpProxy");
//        this.serialNB = serial;
//        this.nodeID = nodeID;       
//    }

    public CanOpenADC(String transmissionType, String serialNB, String nodeID) {
        super(serialNB, nodeID);
        this.transmissionType = transmissionType;
    }
    
    

//    public String getSerialNB() {
//        return this.serialNB;
//    }
//
//    public String getNodeID() {
//        return this.nodeID;
//    }


//    /**
//     * @param serialNB the serialNB to set
//     */
//    public void setSerialNB(String serialNB) {
//        this.serialNB = serialNB;
//    }
//
//    /**
//     * @param nodeID the nodeID to set
//     */
//    public void setNodeID(String nodeID) {
//        this.nodeID = nodeID;
//    }

    public String getTransmissionType() {
        return transmissionType;
    }

    public void setTransmissionType(String transmission_type) {
        this.transmissionType = transmission_type;
    }
    
//
//    @Override
//    public boolean isConfigOK() {
//        return tcpProxy.isNodeIdBootedAndMatchSerialNumber(this);
//    }
    
//    @Override
//    public void initModule() {
//        tcpProxy = (CanOpenProxy) this.getModule("tcpProxy");
//    }
    
    /**
     * Read the analog input whom number is given as a parameter
     * @param input : integer from 1 to 8
     * @return the value read in hexa (on 16bits)
     * @throws SDORequestError 
     */
    public String readAnalogInput(int inputNB) throws SDORequestException, HardwareNotDetectedException {

        log.debug(getName() + " IS BOOTED AND CONFIG OK =" + isNodeIdBootedAndOK());
        if (this.tcpProxy.isBooted(this)) {
             
            //int inputNB = Integer.parseInt(input, 16);
            if ((inputNB < 1) || (inputNB > 8)) 
                throw new IllegalArgumentException("CAN-CBX-AI814 : input has to be 1..8");
            String input = Integer.toHexString(inputNB);
            return tcpProxy.readSDO(nodeID, "6401", input);
            
        } else {
            String message = String.format("Module %s / nodeID=%s is UNREACHABLE", getName(),nodeID);
            log.error(message);
            //this.getSubsystem().updateState(State.InError, message );
            
            throw new HardwareNotDetectedException("CanOpenADC MISSING", this.getName(),this.nodeID,this.serialNB); 
            
        }
    }
    
    @Override
    public String initializeHardware() throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        writeTransmissionTypeToDevice();
        this.initialized = true;
        return getName() + "is initialized with transmission type =" + this.transmissionType;
    }
    

    
    /**
     * This methods writes the transmission type given by the configuration to the device.
     * @return a message
     * @throws SDORequestError
     * @throws ErrorInCommandExecutionException 
     */
    private String writeTransmissionTypeToDevice() throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        if (this.transmissionType == null) throw new BadCommandException(getName() + ": Can't write transmission type to device because transmaission type is null.");
        String ack = this.tcpProxy.writeSDO(this.nodeID, "1801", "2", "1", this.transmissionType);
        String goodAck = "OK";
        if (!ack.equals(goodAck)) throw new ErrorInCommandExecutionException(getName() + " :bad returned ack for wsdo, index 1801");
                
        String ack2 = this.tcpProxy.writeSDO(this.nodeID, "1802", "2", "1", this.transmissionType);
        if (!ack2.equals(goodAck)) throw new ErrorInCommandExecutionException(getName() + " :bad returned ack for wsdo, index 1802");
        return String.format("Transmission type of device %s is now %s", this.name, this.transmissionType);   
    }


    

    
    
    
}
