/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.HashMap;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy.PDOStorage;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

/**
 *
 * @author virieux
 */
public interface BridgeToHardware {

    /**
     * This method returns true if the C-Wrapper is connected to the tcp proxy.
     * The C-Wrapper has to send the tcpProxy clientName as a keyword before
     * any communication can begin. So if the C-Wrapper doesn't send the good
     * keyword or if it doesn't connect to the tcp proxy, this method returns
     * false.
     */
    public boolean isCWrapperConnected();

    /**
     * returns true if the hardware is booted, identified and initialized.
     */
    public boolean isHardwareReady();
    
//    /**
//     * 
//     * @return a list like : nodeID_inputNb=value1, nodeID_inputNb=value2, ......
//     * {23_6=104, 23_7=101, 23_8=112, 23_2=119, 23_3=10, 23_4=109, 23_5=108, 23_1=25a8, 
//     * 01_1=25a8, 01_3=10, 01_2=119, 01_5=108, 01_4=109, 01_7=101, 01_6=104, 01_8=112}
//     */
//    public HashMap<String, String> readSensorsValues() throws HardwareError;
    
    
    public PDOStorage readPDOs() throws HardwareException, BadCommandException;
    
}
