/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

/**
 *
 * @author virieux
 */
public abstract class LatchActuatorModule extends Module  {


    double currentLimitInVolt; // to limit the current sent to the motor
    int speedVoltageInVolt; // to start the motor
    boolean close;
    
    //for the GUI
    public int speedVoltageMinValue;
    public int speedVoltageMaxValue;

    public LatchActuatorModule() {
    }

    /**************************************************************************************************/
    /********************** SETTERS AND GETTERS  ******************************************************/
    /**************************************************************************************************/
    
    public double getCurrentLimitInVolt() {
        return currentLimitInVolt;
    }

    public void setCurrentLimitInVolt(double currentLimitInVolt) {
        this.currentLimitInVolt = currentLimitInVolt;
    }

    public int getSpeedVoltageInVolt() {
        return speedVoltageInVolt;
    }

    public void setSpeedVoltageInVolt(int speedVoltageInVolt) {
        this.speedVoltageInVolt = speedVoltageInVolt;
    }

    public int getSpeedVoltageMaxValue() {
        return speedVoltageMaxValue;
    }

    public void setSpeedVoltageMaxValue(int speedVoltageMaxValue) {
        this.speedVoltageMaxValue = speedVoltageMaxValue;
    }

    public int getSpeedVoltageMinValue() {
        return speedVoltageMinValue;
    }

    public void setSpeedVoltageMinValue(int speedVoltageMinValue) {
        this.speedVoltageMinValue = speedVoltageMinValue;
    }




    



    
    


    /**************************************************************************************************/
    /********************** END OF SETTERS AND GETTERS  ***********************************************/
    /**************************************************************************************************/
    
    /**
     * This is the command that has to be sent to the latch actuator to open the latch (same as unlock it).
     * @return
     * @throws BadCommandException
     * @throws ErrorInCommandExecutionException 
     */
    public abstract String open() throws BadCommandException, ErrorInCommandExecutionException, HardwareException;

    /**
     * This is the command that has to be sent to the latch actuator to close the latch it (same as lock it).
     * @return
     * @throws BadCommandException
     * @throws ErrorInCommandExecutionException 
     */
    public abstract String close() throws BadCommandException, ErrorInCommandExecutionException, HardwareException;
    
    /**
     * Power off the latch actuator.
     * @return
     * @throws BadCommandException
     * @throws ErrorInCommandExecutionException 
     */
    public abstract String powerOff() throws BadCommandException, ErrorInCommandExecutionException, HardwareException;





    
}
