/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.Sensor;

/**
 * This represents a device we use in FCS to connect our numeric sensors(CAN-CBX-DIO8).
 * It has 8 channels. Each channel can be configured to be inputs or output channel.
 * So we can plug up to 8 sensors on one CampactIOModule.
 * We read all the inputs channels in the same commands.
 * This class should be extended for the real hardware and for the simulated hardware.
 * 
 * @author virieux
 */
public abstract class CompactIOModule extends Module implements Sensor {
    
    public String hexaValue;
    
   //updatingValue is true while we are reading the value sent by the Sensor
   //this could take some time
   volatile boolean updatingValue = false;
   final Lock lock = new ReentrantLock();
   final Condition valueUpdated = lock.newCondition();
        
    @Override
   public void initModule() {
       this.hexaValue = "00";
   }
    
    /**
     * 
     * @return a String which is the value in hexa sent by the device.
     */
    abstract public String readNewHexaValue ();
    
    /**
     * @return the hexa value converted in decimal.
     */
    public String getHexaValue() {
       lock.lock();
       try {
           while (updatingValue) {
                try {
                    //TODO put a timeout
                    valueUpdated.await();
                } catch (InterruptedException ex) {
                    log.error(getName() + ex.getMessage());
      
                }
           }
           return this.hexaValue;
       } finally {
           lock.unlock();
       }
    }
   
    
    
    /**
     * @return the hexa value converted in decimal.
     */
    @Override
    public int getValue() {
        //log.debug(getName() + Integer.parseInt(getHexaValue(), 16));
        return Integer.parseInt(getHexaValue(), 16);
    }

    
    @Override
    public void updateValue() {
       //log.debug(getName() + ":" + Thread.currentThread().toString());
       lock.lock();
       
       updatingValue = true;
       
       try {
            this.hexaValue = readNewHexaValue();
            //log.debug(getName() + "HEXA VALUE READ=" + this.hexaValue);

       } finally {
           updatingValue = false;
           valueUpdated.signal();
           lock.unlock();
       }
    }
        
    
    
     /**
     * The String argument represents an integer in hexa.
     * This methods eturns a string representation of this integer argument as an unsigned integer in base 2.
     * @param Hex
     * @return the binary form of this integer with 8 digits
     * examples :
     * HexToBinary(4)  returns 00000100
     * HexToBinary(AA) returns 10101010
     * HexToBinary(FF) returns 11111111
     */
    public static String hexToBinary(String Hex) {
        int integer = Integer.parseInt(Hex, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%08d", Integer.parseInt(bin));
    }
    
    
    /**
     * 
     * @param bin
     * @return 
     */
    public static String binaryToHex(String bin) {
        int binaryToInt = Integer.parseInt(bin, 2);
        return Integer.toHexString(binaryToInt);
    }
    
    
    
}
