/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.Actuator;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 * A model for the clamp actuator.
 * The clamp actuator is used to unlock the clamp that hold a filter on the carousel.
 * It's an abstract class as it can be implemented by a real actuator driver class or by 
 * a simulted hardware class.
 * 
 * @author virieux
 */
public abstract class ClampActuatorModule extends Module implements Actuator {
    public boolean on;
    public int readValue;
    public int sentValue;
    public int sentCurrentMinValue;
    public int sentCurrentMaxValue;

    
    
    
    public ClampActuatorModule() {
        this.on = false;
        this.readValue = 0;
        this.sentValue = 0;
    }

    @Override
    public boolean isOff() {
        return !on;
    }

    @Override
    public boolean isOn() {
        return on;
    }
    
    public int getReadValue() {
        return readValue;
    }
    
    public int getSentValue() {
        return sentValue;
    }

    public int getSentCurrentMaxValue() {
        return sentCurrentMaxValue;
        //could change
//        return this.getMotor_continuousCurrentLimit();
    }

    public void setSentCurrentMaxValue(int sentCurrentMaxValue) {
        this.sentCurrentMaxValue = sentCurrentMaxValue;
    }

    public int getSentCurrentMinValue() {
        return sentCurrentMinValue;
    }

    public void setSentCurrentMinValue(int sentCurrentMinValue) {
        this.sentCurrentMinValue = sentCurrentMinValue;
    }

    
    

    
    /* This method send the command ON on the actuator hardware.
     * It has to update the readValue, value which is read on the actuator hardware.
     */
    @Override
    public abstract String on() throws BadCommandException, ErrorInCommandExecutionException;
    
    /* This method send the command OFF on the actuator hardware.
     * It has to update the readValue, value which is read on the actuator hardware.
     */
    public abstract String off() throws BadCommandException, ErrorInCommandExecutionException;
    
    public abstract String maintainUnclamped() throws BadCommandException, ErrorInCommandExecutionException;
    
    public abstract int getMotor_continuousCurrentLimit();

    public abstract int getMotor_maxSpeedInCurrentMode();
   

    public abstract String getMotor_mode();


    public abstract int getMotor_outputCurrentLimit();


    public abstract int getMotor_polePairNumber();


    public abstract int getMotor_thermalTimeConstantWinding();


    public abstract int getMotor_type();


    public abstract String getNodeID();


    public abstract int getPositionSensorType();


    public abstract String getSerialNB();
    
    public StatusDataPublishedByClampActuator getStatusData() {
        return FcsUtils.createStatusDataPublishedByClampActuator(this);
    }
    
    
}
