#!/bin/sh -x
#
# CCS worker subsystem startup template
#-----------------------------------------------------------
#-- project specifics
proj=org-lsst-ccs-subsystem-fcs-main
pkg=org.lsst.ccs.startup
mclass=SubsystemBoot
#dfile=<mandatory descriptionfile>
#dfile=etc/org/lsst/ccs/subsystems/fcs/conf/single-filter-test__hardware.groovy
#type has to be : hardware or simulation
type=$1
uname="Correct command is : $0 TYPE where TYPE is hardware or simulation"
if [ ! -e $type]; then
	echo "$uname"
        exit 0
fi
dfile=etc/org/lsst/ccs/subsystems/fcs/conf/single-filter-test__$type.groovy
#cfile=<optional-cfgfile>
cfile=
#- example
#dfile=etc/new-ccs-vst.groovy
#cfile=
#
#-- get canonical paths, note if readlink fails, falls back to $0
#
#rpath=$(readlink -fn $0 2>/dev/null) || rpath=$0
rpath=$(readlink -n $0 2>/dev/null) || rpath=$0
rname=${rpath##*/}       #- name comes after last /
rdir=${rpath%/*}         #- dirname of this script
bdir=${rdir%/*}          #- base dir with {bin,lib,etc,share,...}
echo "Software directory=$bdir"
echo "description file=$bdir/$dfile"
if [ ! -e ${bdir}/share/java ]; then
	   echo "error:" bad path $0, ${bdir}/share/java not found
	      exit 1
      fi

      #-- get the last jar file in std sort order (eg 1.1 is after 1.0)
      jar=$(ls -1 $bdir/share/java/${proj}*jar | sed '$ !d')
      echo "jar=$jar"


      #-- set LD_LIBRARY_PATH for distribution standard
      LDP=${bdir}/lib/jni:${bdir}/lib

      #-- cfile option
      if [ "XXX"${cfile} != "XXX" ]; then 
	      CFG=" --configfile ${cfile}"
      fi

      #-- run the CLASS
      
      echo "LD_LIBRARY_PATH=${LDP} java -cp ${bdir}/etc:${jar} ${pkg}.${mclass} --description ${bdir}/$dfile $CFG"
      LD_LIBRARY_PATH=${LDP} java -D"org.lsst.ccs.resources.directory=${bdir}/etc" -cp ${bdir}/etc:${jar} ${pkg}.${mclass} --description ${bdir}/$dfile $CFG
