/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDAC;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.testbench.Led;

public class CanOpenLED
extends Module
implements Led {
    CanOpenDAC dac;
    String dacName;
    int outputNumero;
    String currentValue;

    public CanOpenDAC getDac() {
        return this.dac;
    }

    public void setDac(CanOpenDAC dac) {
        this.dac = dac;
    }

    public String getDacName() {
        return this.dacName;
    }

    public void setDacName(String dacName) {
        this.dacName = dacName;
    }

    public int getOutputNumero() {
        return this.outputNumero;
    }

    public void setOutputNumero(int outputNumero) {
        this.outputNumero = outputNumero;
    }

    public void initModule() {
        this.dac = (CanOpenDAC)this.getModule(this.dacName);
    }

    @Override
    public String turnON() throws SDORequestException, HardwareNotDetectedException {
        this.sentCurrent(this.name);
        return "LED is turn ON";
    }

    @Override
    public String turnOFF() throws SDORequestException, HardwareNotDetectedException {
        this.dac.writeAnalogOutput(this.outputNumero, 0);
        return "LED is turn OFF";
    }

    public String sentCurrent(String hexa) throws SDORequestException, HardwareNotDetectedException {
        this.dac.writeAnalogOutput(this.outputNumero, Integer.parseInt(hexa, 16));
        return "LED is turn ON";
    }
}

