/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsAlarm;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftCarouselModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SftMainModule
extends MainModule {
    private Filter dummyFilter;
    private SftCarouselModule carousel;
    private SftAutoChangerModule autochanger;
    private boolean filterLocated;

    public Filter getDummyFilter() {
        return this.dummyFilter;
    }

    public void setDummyFilter(Filter dummyFilter) {
        this.dummyFilter = dummyFilter;
    }

    public BridgeToHardware getBridge() {
        return this.bridge;
    }

    public void setBridge(BridgeToHardware bridge) {
        this.bridge = bridge;
    }

    public void initModule() {
        this.carousel = (SftCarouselModule)this.getModule("carousel");
        this.autochanger = (SftAutoChangerModule)this.getModule("autochanger");
        this.hardwareReady = false;
        this.filterLocated = false;
    }

    public void tick() {
        if (this.isHardwareReady() && !this.filterLocated) {
            try {
                this.locateFilter();
                this.filterLocated = true;
                log.debug((Object)"Filter has been located", new String[0]);
            }
            catch (Exception ex) {
                this.filterLocated = false;
                log.error((Object)ex.getMessage(), new String[0]);
                FcsAlarm alarm = new FcsAlarm(ex.toString());
                this.sendToStatus((Status)alarm);
            }
        }
    }

    public void locateFilter() throws HardwareException, ErrorInCommandExecutionException, BadCommandException {
        this.carousel.updateClampsStateWithSensors();
        if (this.carousel.getClampXminus().getClampState().equals((Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER) || this.carousel.getClampXminus().getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
            this.carousel.getSockets()[0].putFilterOnSocket(this.dummyFilter);
        }
        this.autochanger.updateLatchesStateWithSensors();
        if (!this.autochanger.isTrucksEmpty()) {
            this.autochanger.setFilterOnTrucks(this.dummyFilter);
        }
        this.autochanger.updateTrucksLocationWithSensors();
    }

    public void checkPreConditionsForUnlockClamps() throws HardwareException, BadCommandException, ErrorInCommandExecutionException {
        this.updateStateWithSensors();
        if (this.carousel.isHoldingFilterAtStandby() && !this.autochanger.isHoldingFilterAtStandby()) {
            throw new ErrorInCommandExecutionException("Can't unlock clamps if filter is not held by autochanger.");
        }
    }

    public String displayData() {
        StringBuilder sb = new StringBuilder("Data published by ");
        sb.append(this.getContext().getSubsystem().getName()).append("\n  ");
        sb.append(CarouselModule.publishedByCarouselOutputName);
        log.debug((Object)("Carousel status=" + this.carousel.getStatusData().toString()), new String[0]);
        sb.append(this.carousel.getStatusData().toString());
        sb.append("\n  ");
        sb.append("clampXminus status=");
        sb.append(this.carousel.getClampXminus().getStatusData().toString());
        sb.append("\n  ");
        sb.append("clampXplus status=");
        sb.append(this.carousel.getClampXplus().getStatusData().toString());
        sb.append("\n  ");
        sb.append(AutoChangerModule.publishedByAutoChangerOutputName);
        log.debug((Object)("autochanger status=" + this.autochanger.getStatusData().toString()), new String[0]);
        sb.append(this.autochanger.getStatusData().toString());
        sb.append("\n  ");
        sb.append("latchXminus status=");
        sb.append(this.autochanger.getLatchXminus().getStatusData().toString());
        sb.append("\n  ");
        sb.append("latchXplus status=");
        sb.append(this.autochanger.getLatchXplus().getStatusData().toString());
        sb.append("\n  ");
        return sb.toString();
    }

    public String goToInitialStateForSequence1() {
        return null;
    }

    public String executeSequence1() throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        log.debug((Object)"=======> Autochanger trucks moving empty to standby position.", new String[0]);
        this.autochanger.grabFilterAtStandby(this.dummyFilter);
        log.debug((Object)"=======> Carousel is ungrabbing filter at standby position.", new String[0]);
        this.carousel.ungrabbeFilterAtStandby(this.dummyFilter);
        log.debug((Object)"=======> Autochanger trucks moving loaded with the filter to standback position.", new String[0]);
        this.autochanger.moveFilterToStandback(this.dummyFilter);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(SftMainModule.class.getName()).log(Level.SEVERE, null, ex);
        }
        log.debug((Object)"=======> Carousel about to release Clamps.", new String[0]);
        this.carousel.releaseClamps();
        log.debug((Object)"=======> Autochanger trucks moving back the filter to standby position.", new String[0]);
        this.autochanger.moveFilterToStandby(this.dummyFilter);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(SftMainModule.class.getName()).log(Level.SEVERE, null, ex);
        }
        log.debug((Object)"=======> Carousel is grabbing filter at standby position.", new String[0]);
        this.carousel.grabbeFilterAtStandby(this.getDummyFilter());
        log.debug((Object)"=======> Autochanger moving back empty to online position.", new String[0]);
        this.autochanger.ungrabFilterAtStandby();
        return String.valueOf(this.getName()) + " Execution of Sequence1 completed";
    }

    public String executeSequence1(int nb) throws BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        if (nb < 1 || nb > 20000) {
            throw new IllegalArgumentException("nb has to be comprise between 1 and 20000");
        }
        int i = 1;
        while (i < nb + 1) {
            log.info((Object)("===========================BEGIN execution Sequence1 nb=" + i + " ================"), new String[0]);
            this.executeSequence1();
            log.info((Object)("===========================END execution Sequence1 nb=" + i + " ================"), new String[0]);
            ++i;
        }
        return String.valueOf(this.getName()) + ":" + nb + " executions of Sequence1 completed";
    }

    boolean autochangerLatchesAreLocked() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Filter getFilterAtStandby() {
        return this.carousel.getFilterAtStandby();
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.carousel.sendToStatus((Status)this.carousel.getStatusData());
        this.autochanger.sendToStatus((Status)this.autochanger.getStatusData());
    }

    public String printFilters() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getName()) + " printFilters \n ");
        sb.append(this.dummyFilter.getName());
        sb.append(" position: ").append(this.carousel.getFilterPosition(this.dummyFilter));
        sb.append(" socket number: ").append(this.carousel.getSocketNumber(this.dummyFilter));
        sb.append(" standby position: ").append(this.carousel.getStandbyPositionForFilter(this.dummyFilter));
        log.info((Object)sb.toString(), new String[0]);
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n").append(this.carousel.toString());
        sb.append("\n").append(this.autochanger.toString());
        return sb.toString();
    }

    public void updateStateWithSensors() throws HardwareException, ErrorInCommandExecutionException, BadCommandException {
        this.carousel.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
    }

    public SftCarouselModule getCarouselModule() {
        return this.carousel;
    }

    public SftAutoChangerModule getAutoChangerModule() {
        return this.autochanger;
    }

    public SingleFilterTestConfig getFullState() {
        return FcsUtils.createSingleFilterTestConfig(this);
    }
}

