/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenADC;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

public class CanOpenSensor14bits
extends Sensor14bits {
    CanOpenADC adc;
    String adcName;
    int numOfAnalogInput;

    public CanOpenADC getAdc() {
        return this.adc;
    }

    public void setAdc(CanOpenADC adc) {
        this.adc = adc;
    }

    public String getAdcName() {
        return this.adcName;
    }

    public void setAdcName(String adcName) {
        this.adcName = adcName;
    }

    public int getNumOfAnalogInput() {
        return this.numOfAnalogInput;
    }

    public void setNumOfAnalogInput(int numOfAnalogInput) {
        this.numOfAnalogInput = numOfAnalogInput;
    }

    @Override
    public void initModule() {
        this.adc = (CanOpenADC)this.getModule(this.adcName);
    }

    @Override
    public int readNewValue() throws HardwareException {
        String valueInHexa = this.adc.readAnalogInput(this.numOfAnalogInput);
        this.value = Integer.parseInt(valueInHexa, 16);
        return this.value;
    }

    @Override
    public int updateValue(CanOpenProxy.PDOStorage pdoStorage) {
        String hexaValue = pdoStorage.getVarValue(this.adc.nodeID, Integer.toString(this.numOfAnalogInput));
        this.value = Integer.parseInt(hexaValue, 16);
        return this.value;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/adcName=");
        sb.append(this.adcName);
        sb.append("/inputNumero=");
        sb.append(this.numOfAnalogInput);
        return sb.toString();
    }
}

