/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class CanOpenADC
extends CanOpenDevice {
    public static final double adcVoltsPerBit = 0.3125;
    public static final double waterFreezeTemp = 273.15;
    String transmissionType;

    public CanOpenADC() {
    }

    public CanOpenADC(String transmissionType, String serialNB, String nodeID) {
        super(serialNB, nodeID);
        this.transmissionType = transmissionType;
    }

    public String getTransmissionType() {
        return this.transmissionType;
    }

    public void setTransmissionType(String transmission_type) {
        this.transmissionType = transmission_type;
    }

    public String readAnalogInput(int inputNB) throws SDORequestException, HardwareNotDetectedException {
        log.debug((Object)(String.valueOf(this.getName()) + " IS BOOTED AND CONFIG OK =" + this.isNodeIdBootedAndOK()), new String[0]);
        if (this.tcpProxy.isBooted(this)) {
            if (inputNB < 1 || inputNB > 8) {
                throw new IllegalArgumentException("CAN-CBX-AI814 : input has to be 1..8");
            }
            String input = Integer.toHexString(inputNB);
            return this.tcpProxy.readSDO(this.nodeID, "6401", input);
        }
        String message = String.format("Module %s / nodeID=%s is UNREACHABLE", this.getName(), this.nodeID);
        log.error((Object)message, new String[0]);
        throw new HardwareNotDetectedException("CanOpenADC MISSING", this.getName(), this.nodeID, this.serialNB);
    }

    @Override
    public String initializeHardware() throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        this.writeTransmissionTypeToDevice();
        this.initialized = true;
        return String.valueOf(this.getName()) + "is initialized with transmission type =" + this.transmissionType;
    }

    private String writeTransmissionTypeToDevice() throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        String goodAck;
        if (this.transmissionType == null) {
            throw new BadCommandException(String.valueOf(this.getName()) + ": Can't write transmission type to device because transmaission type is null.");
        }
        String ack = this.tcpProxy.writeSDO(this.nodeID, "1801", "2", "1", this.transmissionType);
        if (!ack.equals(goodAck = "OK")) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " :bad returned ack for wsdo, index 1801");
        }
        String ack2 = this.tcpProxy.writeSDO(this.nodeID, "1802", "2", "1", this.transmissionType);
        if (!ack2.equals(goodAck)) {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + " :bad returned ack for wsdo, index 1802");
        }
        return String.format("Transmission type of device %s is now %s", this.name, this.transmissionType);
    }
}

