/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.state.State;
import org.lsst.ccs.subsystems.fcs.FcsAlarm;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

public abstract class MobileItemModule
extends Module {
    protected boolean itemMoving = false;
    public final Lock lock = new ReentrantLock();
    public final Condition motionCompleted = this.lock.newCondition();
    ScheduledFuture<?> readSensorsHandle;
    final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);

    public void cancelReadingSensors() {
        this.lock.lock();
        try {
            log.debug((Object)" => Stop reading sensors", new String[0]);
            this.motionCompleted.signal();
        }
        finally {
            this.lock.unlock();
        }
        this.readSensorsHandle.cancel(true);
        log.debug((Object)"readingSensors canceled", new String[0]);
    }

    public abstract boolean isActionCompleted(FcsEnumerations.MobileItemAction var1);

    public abstract void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception;

    public abstract void startAction(FcsEnumerations.MobileItemAction var1) throws BadCommandException, ErrorInCommandExecutionException, HardwareException;

    public abstract void postAction(FcsEnumerations.MobileItemAction var1) throws BadCommandException, ErrorInCommandExecutionException, HardwareException;

    public String executeAction(FcsEnumerations.MobileItemAction action, long timeoutForAction) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        this.lock.lock();
        this.itemMoving = true;
        try {
            this.startAction(action);
            this.readSensorsUntilActionIsCompleted(action, System.currentTimeMillis(), timeoutForAction);
            this.waitForEndOfAction(action);
            if (this.isActionCompleted(action)) {
                this.postAction(action);
                String string = String.valueOf(this.getName()) + " " + action.doneString();
                return string;
            }
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": " + action.getFailureMsg());
        }
        finally {
            this.itemMoving = false;
            this.motionCompleted.signal();
            this.lock.unlock();
        }
    }

    public void readSensorsUntilActionIsCompleted(final FcsEnumerations.MobileItemAction action, final long beginTime, final long timeout) {
        Runnable readSensors = new Runnable(){

            @Override
            public void run() {
                try {
                    log.debug((Object)"Socket at standby : Reading sensors", new String[0]);
                    long duration = System.currentTimeMillis() - beginTime;
                    MobileItemModule.this.updateStateWithSensorsToCheckIfActionIsCompleted();
                    boolean actionCompleted = MobileItemModule.this.isActionCompleted(action);
                    if (!actionCompleted && duration < timeout) {
                        log.debug((Object)(String.valueOf(action.toString()) + " not completed....."), new String[0]);
                    } else if (actionCompleted) {
                        MobileItemModule.this.itemMoving = false;
                        log.debug((Object)(String.valueOf(action.toString()) + " ACTION COMPLETED"), new String[0]);
                        MobileItemModule.this.cancelReadingSensors();
                    } else if (duration >= timeout) {
                        MobileItemModule.this.itemMoving = false;
                        log.debug((Object)(String.valueOf(action.toString()) + " ACTION NOT COMPLETED during allocated time"), new String[0]);
                        MobileItemModule.this.cancelReadingSensors();
                        throw new TimeoutException(String.valueOf(action.toString()) + " clamps at standby was greater than timeout for this task: duration=" + duration + ",timeout=" + timeout);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("ERROR during action:" + ex.getMessage()), new String[0]);
                    ex.printStackTrace();
                    FcsAlarm alarm = new FcsAlarm(ex.toString());
                    MobileItemModule.this.sendToStatus((Status)alarm);
                    MobileItemModule.this.getSubsystem().updateState(State.InError, "ERROR DURING ACTION " + action.toString() + " " + ex.toString());
                    MobileItemModule.this.cancelReadingSensors();
                }
            }
        };
        this.readSensorsHandle = this.scheduler.scheduleAtFixedRate(readSensors, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    /*
     * Exception decompiling
     */
    public void waitForEndOfAction(FcsEnumerations.MobileItemAction action) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void shutdownNow() {
        super.shutdownNow();
        this.scheduler.shutdown();
    }
}

