/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.common.FilterLocation;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

public class FcsMainModule
extends Module {
    private static final long serialVersionUID = 7669526660659959402L;
    private CarouselModule carousel;
    private AutoChangerModule autochanger;
    private Double standbyPosition;
    private Map<String, Filter> filters = new HashMap<String, Filter>();
    private static final String ack = "[FCSMainModule]";

    public void initModule() {
        log.info((Object)"[FcsMainModule] Initializing the FCS Main module ", new String[0]);
        try {
            this.carousel = (CarouselModule)this.getModule("carousel");
            this.autochanger = (AutoChangerModule)this.getModule("autochanger");
            this.locateFilters();
            this.autochanger.locateTrucks();
            log.info((Object)("SUBSYSTEM NAME= " + this.getSubsystem().getName()), new String[0]);
            this.publishData(CarouselModule.publishedByCarouselOutputName, (Serializable)this.carousel.getStatusData());
            this.publishData(AutoChangerModule.publishedByAutoChangerOutputName, (Serializable)this.autochanger.getStatusData());
        }
        catch (RuntimeException e) {
            log.fatal((Object)("[FcsMainModule] ERROR: " + this.name + " Initialization failed for FCS main module : " + e.getMessage()), new String[0]);
            throw e;
        }
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        this.publishData(v.getName(), v.getValue());
    }

    public String printFilters() {
        String message = "[FCSMainModule] printFilters \n ";
        for (String key : this.filters.keySet()) {
            message = String.valueOf(message) + this.filters.get(key).getName() + " " + (Object)((Object)this.filters.get(key).getFilterLocation());
            if (this.filters.get(key).isOnCarousel()) {
                message = String.valueOf(message) + " position: " + this.carousel.getFilterPosition(this.filters.get(key));
                message = String.valueOf(message) + " socket number: " + this.carousel.getSocketNumber(this.filters.get(key));
                message = String.valueOf(message) + " standby position: " + this.carousel.getStandbyPositionForFilter(this.filters.get(key));
            }
            message = String.valueOf(message) + " \n ";
        }
        log.info((Object)message, new String[0]);
        return message;
    }

    public String displayData() {
        StringBuilder sb = new StringBuilder("Data published by ");
        sb.append(this.getContext().getSubsystem().getName()).append("\n  ");
        sb.append(CarouselModule.publishedByCarouselOutputName);
        sb.append(this.carousel.getStatusData().toString()).append("\n  ");
        sb.append(AutoChangerModule.publishedByAutoChangerOutputName);
        sb.append(this.autochanger.getStatusData().toString());
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(this.carousel.toString());
        sb.append(this.autochanger.toString());
        return sb.toString();
    }

    public void shutdown() {
        this.getContext().getSubsystem().shutdown();
    }

    public String stop(String moduleName) throws IllegalArgumentException {
        if (moduleName == null) {
            throw new IllegalArgumentException("Please enter the FCS subsystem you want to stop : carousel, autochanger or fliprail");
        }
        if (moduleName.equals("carousel")) {
            return this.carousel.stop();
        }
        if (moduleName.equals("autochanger")) {
            return this.autochanger.stop();
        }
        if (moduleName.equals("fliprail")) {
            return this.autochanger.getFliprail().stop();
        }
        throw new IllegalArgumentException("Bad module name : must be carousel or autochanger or fliprail ");
    }

    public String moveFilterToOnline(Object filterName) throws InterruptedException, IllegalArgumentException, BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        this.controlFilterName(filterName);
        log.info((Object)("Filter to move : " + filterName), new String[0]);
        log.info((Object)("Filter location :" + (Object)((Object)this.getFilterByName((String)filterName).getFilterLocation())), new String[0]);
        return ack + this.moveFilterToOnline(this.getFilterByName((String)filterName));
    }

    public String moveFilterToStandby(Object filterName) throws InterruptedException, IllegalArgumentException, BadCommandException, ErrorInCommandExecutionException {
        this.controlFilterName(filterName);
        log.info((Object)("Filter to move : " + filterName), new String[0]);
        log.info((Object)("Filter location : " + (Object)((Object)this.getFilterByName((String)filterName).getFilterLocation())), new String[0]);
        return ack + this.moveFilterToStandby(this.getFilterByName((String)filterName));
    }

    private void locateFilters() {
        this.carousel.getSockets()[0].putFilterOnSocket(this.filters.get("filterU"));
        this.carousel.getSockets()[1].putFilterOnSocket(this.filters.get("filterG"));
        this.carousel.getSockets()[2].putFilterOnSocket(this.filters.get("filterR"));
        this.carousel.getSockets()[3].putFilterOnSocket(this.filters.get("filterI"));
        this.carousel.getSockets()[4].putFilterOnSocket(this.filters.get("filterZ"));
        this.carousel.engageClampsContact();
        this.filters.get("filterY").setFilterLocation(FilterLocation.OUT);
    }

    private String moveFilterToOnline(Filter filter) throws InterruptedException, BadCommandException, ErrorInCommandExecutionException, HardwareException, CanOpenException {
        if (this.carousel.isRotating() || this.autochanger.isMoving()) {
            throw new BadCommandException(String.valueOf(this.getName()) + " Please wait the end of the last command or send a stop command.");
        }
        if (filter == this.autochanger.getFilterOnTrucks()) {
            return this.autochanger.moveFilterToOnline(filter);
        }
        if (filter.isOnCarousel()) {
            if (!this.autochanger.isTrucksEmpty()) {
                Filter filterOnTrucks = this.autochanger.getFilterOnTrucks();
                if (!this.carousel.isReadyToGrabbeAFilterAtStandby()) {
                    throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + "/Carousel is not ready to grabbe a filter at standby position");
                }
                this.autochanger.moveFilterToStandby(filterOnTrucks);
                this.carousel.grabbeFilterAtStandby(filterOnTrucks);
                this.autochanger.ungrabFilterAtStandby();
            }
            this.carousel.moveFilterToStandby(filter);
            this.autochanger.grabFilterAtStandby(filter);
            this.carousel.ungrabbeFilterAtStandby(filter);
            this.autochanger.moveFilterToOnline(filter);
            this.carousel.releaseClamps();
            this.autochanger.closeOnlineClamp();
            return String.valueOf(this.getName()) + ": command moveFilterToOnline completed / filter on line: " + filter.getName();
        }
        String message = "Panic : filter is neither on carousel, neither on autochanger";
        log.error((Object)message, new String[0]);
        return message;
    }

    private String moveFilterToStandby(Filter filter) throws BadCommandException, InterruptedException, ErrorInCommandExecutionException {
        String message = null;
        if (filter.isOnCarousel()) {
            message = this.carousel.moveFilterToStandby(filter);
        } else if (filter.isOnAutoChanger()) {
            message = this.autochanger.moveFilterToStandby(filter);
        }
        return message;
    }

    public Filter getFilterAtStandby() {
        return this.carousel.getFilterAtStandby();
    }

    protected void controlFilterName(Object o) throws IllegalArgumentException {
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("Incorrect filter name : " + o);
        }
        String filterName = (String)o;
        if (!this.filters.containsKey(filterName)) {
            throw new IllegalArgumentException("Unknown filter name : " + o);
        }
        if (this.getFilterByName(filterName).isUnknown()) {
            throw new IllegalArgumentException("Filter: " + o + " is at unknown location.");
        }
        if (this.getFilterByName(filterName).isOut()) {
            throw new IllegalArgumentException("Filter: " + o + " is out of the camera.");
        }
    }

    public Filter getFilterByName(String filterName) {
        return this.filters.get(filterName);
    }

    public boolean isEmptyStandBy() {
        return false;
    }

    public boolean isEmptyOnline() {
        return true;
    }

    protected Filter getFilterOnline() {
        return this.autochanger.getFilterOnline();
    }

    public Map<String, Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Filter> filters) {
        this.filters = filters;
    }

    public Double getStandbyPosition() {
        return this.standbyPosition;
    }

    public void setStandbyPosition(Double standbyPosition) {
        this.standbyPosition = standbyPosition;
    }
}

