/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterClampModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.FilterLocation;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.ClampsOrLatchesDisagreeException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareException;

public class CarouselSocket
extends MobileItemModule {
    private BridgeToHardware bridge;
    private FilterClampModule clampXminus;
    private FilterClampModule clampXplus;
    private double position;
    private double standbyPosition;
    private Filter filter;
    volatile boolean updatingClamps = false;
    private volatile FcsEnumerations.FilterClampState clampsState = FcsEnumerations.FilterClampState.UNDEFINED;
    final Condition stateUpdated = this.lock.newCondition();
    private long timeoutForUnlocking = 4000L;
    private long timeoutForReleasing = 4000L;

    public CarouselSocket() {
    }

    public CarouselSocket(double position) {
        this.position = position;
        this.standbyPosition = position == 0.0 ? 0.0 : 360.0 - position;
    }

    public BridgeToHardware getBridge() {
        return this.bridge;
    }

    public void setBridge(BridgeToHardware bridge) {
        this.bridge = bridge;
    }

    public FilterClampModule getClampXminus() {
        return this.clampXminus;
    }

    public void setClampXminus(FilterClampModule clampXminus) {
        this.clampXminus = clampXminus;
    }

    public FilterClampModule getClampXplus() {
        return this.clampXplus;
    }

    public void setClampXplus(FilterClampModule clampXplus) {
        this.clampXplus = clampXplus;
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double position) {
        this.position = position;
    }

    public Filter getFilter() {
        return this.filter;
    }

    protected void setFilter(Filter filter) {
        this.filter = filter;
    }

    public double getStandbyPosition() {
        return this.standbyPosition;
    }

    public void setStandbyPosition(double standbyPosition) {
        this.standbyPosition = standbyPosition;
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.FilterClampState getClampsState() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public void updateClampsStateWithSensorsFromSDO() throws HardwareException {
        block4: {
            this.lock.lock();
            this.updatingClamps = true;
            try {
                this.clampXminus.updateStateWithSensorsFromSDO();
                this.clampXplus.updateStateWithSensorsFromSDO();
                if (this.clampXminus.getClampState().equals((Object)this.clampXplus.getClampState())) {
                    this.clampsState = this.clampXminus.getClampState();
                    System.out.println("XXXXXXXXSocket at standby : clamps are updated");
                    break block4;
                }
                throw new HardwareException("Error in filter presence detection at standby position : the clamps don't agree.");
            }
            finally {
                this.updatingClamps = false;
                this.stateUpdated.signal();
                this.lock.unlock();
            }
        }
    }

    public void updateClampsStateWithSensors(CanOpenProxy.PDOStorage pdoStorage) throws HardwareException {
        block4: {
            this.lock.lock();
            this.updatingClamps = true;
            try {
                this.clampXminus.updateStateWithSensors(pdoStorage);
                this.clampXplus.updateStateWithSensors(pdoStorage);
                if (this.clampXminus.getClampState().equals((Object)this.clampXplus.getClampState())) {
                    this.clampsState = this.clampXminus.getClampState();
                    log.debug((Object)"XXXXXXXXSocket at standby : clamps are updated", new String[0]);
                    break block4;
                }
                throw new ClampsOrLatchesDisagreeException("Error in filter presence detection at standby position : the clamps don't agree.", this.getName());
            }
            finally {
                this.updatingClamps = false;
                this.stateUpdated.signal();
                this.lock.unlock();
            }
        }
    }

    public void updateClampsStateWithSensors() throws HardwareException, BadCommandException {
        this.updateClampsStateWithSensors(this.bridge.readPDOs());
    }

    public boolean isEmpty() throws HardwareException {
        return this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP) || this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY);
    }

    public boolean isClampedOnFilter() {
        return this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER);
    }

    public boolean isUnclampedOnFilter() {
        return this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER);
    }

    public boolean isUnclampedEmpty() {
        return this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY);
    }

    public boolean isReadyToClamp() {
        return this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP);
    }

    public String releaseClamps() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        this.updateClampsStateWithSensors();
        log.debug((Object)("Checking conditions for release clamp " + this.getName() + " on socket at standby position."), new String[0]);
        if (!this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY)) {
            throw new BadCommandException("Can't release clamps if socket is not unclamped and empty.");
        }
        log.debug((Object)("Releasing clamp " + this.getName() + " on socket at standby position."), new String[0]);
        return this.executeAction(FcsEnumerations.MobileItemAction.RELEASECLAMPS, this.timeoutForReleasing);
    }

    @Deprecated
    public String releaseClampsWithThreadSleep() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        this.lock.lock();
        this.itemMoving = true;
        try {
            this.clampXminus.release();
            this.clampXplus.release();
            if (this.clampXminus.getClampState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP) & this.clampXplus.getClampState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP)) {
                this.clampsState = FcsEnumerations.FilterClampState.READYTOCLAMP;
                System.out.println("XXXXXXXXSocket at standby : clamps are released");
            } else {
                if (!this.clampXminus.getClampState().equals((Object)this.clampXplus.getClampState())) {
                    throw new HardwareException("Error in filter presence detection at standby position : the clamps don't agree.");
                }
                if (!this.clampXminus.getClampState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP)) {
                    throw new ErrorInCommandExecutionException("Could not release clampX-");
                }
                if (!this.clampXplus.getClampState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP)) {
                    throw new ErrorInCommandExecutionException("Could not release clampX+");
                }
            }
        }
        finally {
            this.itemMoving = false;
            this.motionCompleted.signal();
            this.lock.unlock();
        }
        if (this.clampsState.equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP)) {
            return "Clamps are released at standby.";
        }
        return "Unable to release clamps at standby.";
    }

    public String unlockClamps() throws HardwareException, BadCommandException, ErrorInCommandExecutionException {
        this.updateClampsStateWithSensors();
        if (!this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER)) {
            throw new BadCommandException("Can't unlock clamps if isn't clamped on filter.");
        }
        BasicAutoChangerModule autochanger = (BasicAutoChangerModule)this.environment.getComponentByName("autochanger");
        if (autochanger == null) {
            throw new BadCommandException("NO AUTOCHANGER");
        }
        if (!autochanger.isHoldingFilterAtStandby()) {
            throw new BadCommandException("CANNOT UNLOCK CLAMPS if FILTER is not HELD by autochanger.");
        }
        return this.executeAction(FcsEnumerations.MobileItemAction.UNLOCKCLAMPS, this.timeoutForUnlocking);
    }

    @Deprecated
    public String unlockClampsWithThreadSleep() throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        this.lock.lock();
        this.itemMoving = true;
        try {
            this.clampXminus.unlock();
            this.clampXplus.unlock();
            if (this.clampXminus.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER) & this.clampXplus.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
                this.clampsState = FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
            } else {
                if (!this.clampXminus.getClampState().equals((Object)this.clampXplus.getClampState())) {
                    throw new HardwareException("Error in filter presence detection at standby position : the clamps don't agree.");
                }
                if (!this.clampXminus.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
                    throw new ErrorInCommandExecutionException("Could not unlock clampX-");
                }
                if (!this.clampXplus.getClampState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
                    throw new ErrorInCommandExecutionException("Could not unlock clampX+");
                }
            }
        }
        finally {
            this.itemMoving = false;
            this.motionCompleted.signal();
            this.lock.unlock();
        }
        if (this.clampsState.equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER)) {
            return "Clamps are locked at standby.";
        }
        return "Unable to unlock clamps at standby.";
    }

    public void removeFilter() throws BadCommandException {
        if (this.filter == null) {
            throw new BadCommandException("Carousel socket : there is no filter to remove at standby position");
        }
        this.filter = null;
    }

    public synchronized void putFilterOnSocket(Filter filter) {
        this.setFilter(filter);
        filter.setFilterLocation(FilterLocation.ONCAROUSEL);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("Filter in socket : ");
        if (this.getFilter() == null) {
            sb.append(" NO FILTER").append("\n");
        } else {
            sb.append(this.getFilter().getName()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.UNLOCKCLAMPS)) {
            return this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER);
        }
        if (action.equals((Object)FcsEnumerations.MobileItemAction.RELEASECLAMPS)) {
            return this.getClampsState().equals((Object)FcsEnumerations.FilterClampState.READYTOCLAMP);
        }
        throw new IllegalArgumentException("Action on clamps on socket must be UNLOCKCLAMPS or RELEASECLAMPS");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        try {
            this.updateClampsStateWithSensors();
        }
        catch (ClampsOrLatchesDisagreeException clampsOrLatchesDisagreeException) {
            log.debug((Object)(String.valueOf(this.getName()) + "a little delai between the update of the 2 clamps : have to wait ..."), new String[0]);
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.UNLOCKCLAMPS)) {
            this.clampXminus.getActuator().on();
            this.clampXplus.getActuator().on();
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.RELEASECLAMPS)) {
            this.clampXminus.getActuator().off();
            this.clampXplus.getActuator().off();
        } else {
            throw new IllegalArgumentException("Action on clamps on socket must be UNLOCKCLAMPS or RELEASECLAMPS");
        }
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, HardwareException {
    }
}

