/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;

/**
 *
 * @author virieux
 */
public abstract class SftTruckMotor extends Module  {
    
     /* FOR THE GUI 
     * 
     */
    volatile boolean movingToStandby;
    volatile boolean movingToStandback;

    public boolean isMovingToStandback() {
        return movingToStandback;
    }

    public boolean isMovingToStandby() {
        return movingToStandby;
    }

    public void setMovingToStandback(boolean movingToStandback) {
        this.movingToStandback = movingToStandback;
        setChanged();
        this.notifyObservers(new ValueUpdate("IsMovingToStandback", movingToStandback));
    }

    public void setMovingToStandby(boolean movingToStandby) {
        this.movingToStandby = movingToStandby;
        setChanged();
        this.notifyObservers(new ValueUpdate("IsMovingToStandby", movingToStandby));
    }
    
    
    
    public abstract String moveToStandback() throws CanOpenException;
    
    public abstract String moveToStandby() throws CanOpenException;
    
    public abstract String off() throws CanOpenException;
    
}
